/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import hudson.model.TaskListener;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.SlaveComputer;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.PrettyLoggable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.csanchez.jenkins.plugins.kubernetes.AllContainersRunningPodWatcher;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesComputer;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.kohsuke.stapler.DataBoundConstructor;

public class KubernetesLauncher
extends JNLPLauncher {
    @CheckForNull
    private transient AllContainersRunningPodWatcher watcher;
    private static final Logger LOGGER = Logger.getLogger(KubernetesLauncher.class.getName());
    private boolean launched;
    @CheckForNull
    private transient Throwable problem;

    @DataBoundConstructor
    public KubernetesLauncher(String tunnel, String vmargs) {
        super(tunnel, vmargs);
    }

    public KubernetesLauncher() {
    }

    public boolean isLaunchSupported() {
        return !this.launched;
    }

    public void launch(SlaveComputer computer, TaskListener listener) {
        if (!(computer instanceof KubernetesComputer)) {
            throw new IllegalArgumentException("This Launcher can be used only with KubernetesComputer");
        }
        KubernetesComputer kubernetesComputer = (KubernetesComputer)computer;
        computer.setAcceptingTasks(false);
        KubernetesSlave slave = (KubernetesSlave)kubernetesComputer.getNode();
        if (slave == null) {
            throw new IllegalStateException("Node has been removed, cannot launch " + computer.getName());
        }
        if (this.launched) {
            LOGGER.log(Level.INFO, "Agent has already been launched, activating: {}", slave.getNodeName());
            computer.setAcceptingTasks(true);
            return;
        }
        PodTemplate template = slave.getTemplate();
        try {
            int waitedForSlave;
            KubernetesClient client = slave.getKubernetesCloud().connect();
            Pod pod = template.build(slave);
            if (template.isShowRawYaml()) {
                slave.assignPod(pod);
            }
            String podId = pod.getMetadata().getName();
            String namespace = Arrays.asList(pod.getMetadata().getNamespace(), template.getNamespace(), client.getNamespace()).stream().filter(s -> StringUtils.isNotBlank((String)s)).findFirst().orElse(null);
            slave.setNamespace(namespace);
            LOGGER.log(Level.FINE, "Creating Pod: {0}/{1}", new Object[]{namespace, podId});
            pod = (Pod)((NonNamespaceOperation)client.pods().inNamespace(namespace)).create((Object[])new Pod[]{pod});
            LOGGER.log(Level.INFO, "Created Pod: {0}/{1}", new Object[]{namespace, podId});
            listener.getLogger().printf("Created Pod: %s/%s%n", namespace, podId);
            String podName = pod.getMetadata().getName();
            String namespace1 = pod.getMetadata().getNamespace();
            template.getWorkspaceVolume().createVolume(client, pod.getMetadata());
            this.watcher = new AllContainersRunningPodWatcher(client, pod);
            try (Watch _w = (Watch)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace1)).withName(podName)).watch((Object)this.watcher);){
                this.watcher.await(template.getSlaveConnectTimeout(), TimeUnit.SECONDS);
            }
            LOGGER.log(Level.INFO, "Pod is running: {0}/{1}", new Object[]{namespace, podId});
            ImmutableList validStates = ImmutableList.of((Object)"Running");
            int waitForSlaveToConnect = template.getSlaveConnectTimeout();
            SlaveComputer slaveComputer = null;
            String status = null;
            List containerStatuses = null;
            for (waitedForSlave = 0; waitedForSlave < waitForSlaveToConnect; ++waitedForSlave) {
                slaveComputer = slave.getComputer();
                if (slaveComputer == null) {
                    throw new IllegalStateException("Node was deleted, computer is null");
                }
                if (slaveComputer.isOnline()) break;
                pod = (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(podId)).get();
                if (pod == null) {
                    throw new IllegalStateException("Pod no longer exists: " + podId);
                }
                status = pod.getStatus().getPhase();
                if (!validStates.contains(status)) break;
                containerStatuses = pod.getStatus().getContainerStatuses();
                ArrayList<ContainerStatus> terminatedContainers = new ArrayList<ContainerStatus>();
                for (ContainerStatus info : containerStatuses) {
                    if (info == null || info.getState().getTerminated() == null) continue;
                    LOGGER.log(Level.INFO, "Container is terminated {0} [{2}]: {1}", new Object[]{podId, info.getState().getTerminated(), info.getName()});
                    listener.getLogger().printf("Container is terminated %1$s [%3$s]: %2$s%n", podId, info.getState().getTerminated(), info.getName());
                    terminatedContainers.add(info);
                }
                this.checkTerminatedContainers(terminatedContainers, podId, namespace, slave, client);
                LOGGER.log(Level.INFO, "Waiting for agent to connect ({1}/{2}): {0}", new Object[]{podId, waitedForSlave, waitForSlaveToConnect});
                listener.getLogger().printf("Waiting for agent to connect (%2$s/%3$s): %1$s%n", podId, waitedForSlave, waitForSlaveToConnect);
                Thread.sleep(1000L);
            }
            if (slaveComputer == null || slaveComputer.isOffline()) {
                this.logLastLines(containerStatuses, podId, namespace, slave, null, client);
                throw new IllegalStateException("Agent is not connected after " + waitedForSlave + " seconds, status: " + status);
            }
            computer.setAcceptingTasks(true);
            this.launched = true;
            try {
                slave.save();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Could not save() agent: " + e.getMessage(), e);
            }
        }
        catch (Throwable ex) {
            this.setProblem(ex);
            LOGGER.log(Level.WARNING, String.format("Error in provisioning; agent=%s, template=%s", new Object[]{slave, template}), ex);
            LOGGER.log(Level.FINER, "Removing Jenkins node: {0}", slave.getNodeName());
            try {
                slave.terminate();
            }
            catch (IOException | InterruptedException e) {
                LOGGER.log(Level.WARNING, "Unable to remove Jenkins node", e);
            }
            throw Throwables.propagate((Throwable)ex);
        }
    }

    private void checkTerminatedContainers(List<ContainerStatus> terminatedContainers, String podId, String namespace, KubernetesSlave slave, KubernetesClient client) {
        if (!terminatedContainers.isEmpty()) {
            Map<String, Integer> errors = terminatedContainers.stream().collect(Collectors.toMap(ContainerStatus::getName, info -> info.getState().getTerminated().getExitCode()));
            this.logLastLines(terminatedContainers, podId, namespace, slave, errors, client);
            throw new IllegalStateException("Containers are terminated with exit codes: " + errors);
        }
    }

    private void logLastLines(List<ContainerStatus> containers, String podId, String namespace, KubernetesSlave slave, Map<String, Integer> errors, KubernetesClient client) {
        for (ContainerStatus containerStatus : containers) {
            String containerName = containerStatus.getName();
            PrettyLoggable tailingLines = (PrettyLoggable)((ContainerResource)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(podId)).inContainer((Object)containerStatus.getName())).tailingLines(30);
            String log = (String)tailingLines.getLog();
            if (StringUtils.isBlank((String)log)) continue;
            String msg = errors != null ? String.format(" exited with error %s", errors.get(containerName)) : "";
            LOGGER.log(Level.SEVERE, "Error in provisioning; agent={0}, template={1}. Container {2}{3}. Logs: {4}", new Object[]{slave, slave.getTemplate(), containerName, msg, tailingLines.getLog()});
        }
    }

    @CheckForNull
    public Throwable getProblem() {
        return this.problem;
    }

    public void setProblem(@CheckForNull Throwable problem) {
        this.problem = problem;
    }

    public AllContainersRunningPodWatcher getWatcher() {
        return this.watcher;
    }
}

