/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Queue;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.PrettyLoggable;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.framework.io.ByteBuffer;
import org.kohsuke.stapler.framework.io.LargeText;

public class KubernetesComputer
extends AbstractCloudComputer<KubernetesSlave> {
    private static final Logger LOGGER = Logger.getLogger(KubernetesComputer.class.getName());

    public KubernetesComputer(KubernetesSlave slave) {
        super((AbstractCloudSlave)slave);
    }

    public void taskAccepted(Executor executor, Queue.Task task) {
        super.taskAccepted(executor, task);
        Queue.Executable exec = executor.getCurrentExecutable();
        LOGGER.log(Level.FINE, " Computer {0} accepted task {1}", new Object[]{this, exec});
    }

    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        Queue.Executable exec = executor.getCurrentExecutable();
        LOGGER.log(Level.FINE, " Computer {0} completed task {1}", new Object[]{this, exec});
        super.taskCompleted(executor, task, durationMS);
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        super.taskCompletedWithProblems(executor, task, durationMS, problems);
        Queue.Executable exec = executor.getCurrentExecutable();
        LOGGER.log(Level.FINE, " Computer {0} completed task {1} with problems", new Object[]{this, exec});
    }

    @Exported
    public List<Container> getContainers() throws UnrecoverableKeyException, CertificateEncodingException, NoSuchAlgorithmException, KeyStoreException, IOException {
        if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            LOGGER.log(Level.FINE, " Computer {0} getContainers, lack of admin permission, returning empty list", (Object)this);
            return Collections.emptyList();
        }
        KubernetesSlave slave = (KubernetesSlave)this.getNode();
        if (slave == null) {
            return Collections.emptyList();
        }
        KubernetesCloud cloud = slave.getKubernetesCloud();
        KubernetesClient client = cloud.connect();
        String namespace = StringUtils.defaultIfBlank((String)slave.getNamespace(), (String)client.getNamespace());
        Pod pod = (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(this.getName())).get();
        return pod.getSpec().getContainers();
    }

    @Exported
    public List<Event> getPodEvents() throws UnrecoverableKeyException, CertificateEncodingException, NoSuchAlgorithmException, KeyStoreException, IOException {
        if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            LOGGER.log(Level.FINE, " Computer {0} getPodEvents, lack of admin permission, returning empty list", (Object)this);
            return Collections.emptyList();
        }
        KubernetesSlave slave = (KubernetesSlave)this.getNode();
        if (slave != null) {
            KubernetesCloud cloud = slave.getKubernetesCloud();
            KubernetesClient client = cloud.connect();
            String namespace = StringUtils.defaultIfBlank((String)slave.getNamespace(), (String)client.getNamespace());
            Pod pod = (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(this.getName())).get();
            if (pod != null) {
                ObjectMeta podMeta = pod.getMetadata();
                String podNamespace = podMeta.getNamespace();
                HashMap<String, String> fields = new HashMap<String, String>();
                fields.put("involvedObject.uid", podMeta.getUid());
                fields.put("involvedObject.name", podMeta.getName());
                fields.put("involvedObject.namespace", podNamespace);
                EventList eventList = (EventList)((FilterWatchListDeletable)((NonNamespaceOperation)client.events().inNamespace(podNamespace)).withFields(fields)).list();
                if (eventList != null) {
                    return eventList.getItems();
                }
            }
        }
        return Collections.emptyList();
    }

    public void doContainerLog(@QueryParameter String containerId, StaplerRequest req, StaplerResponse rsp) throws UnrecoverableKeyException, CertificateEncodingException, NoSuchAlgorithmException, KeyStoreException, IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        ByteBuffer outputStream = new ByteBuffer();
        KubernetesSlave slave = (KubernetesSlave)this.getNode();
        if (slave != null) {
            KubernetesCloud cloud = slave.getKubernetesCloud();
            KubernetesClient client = cloud.connect();
            String namespace = StringUtils.defaultIfBlank((String)slave.getNamespace(), (String)client.getNamespace());
            ((PrettyLoggable)((ContainerResource)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(this.getName())).inContainer((Object)containerId)).tailingLines(20)).watchLog((OutputStream)outputStream);
        }
        new LargeText(outputStream, false).doProgressText(req, rsp);
    }

    public String toString() {
        return String.format("KubernetesComputer name: %s slave: %s", this.getName(), this.getNode());
    }

    public ACL getACL() {
        final ACL base = super.getACL();
        return new ACL(){

            public boolean hasPermission(Authentication a, Permission permission) {
                return permission == Computer.CONFIGURE ? false : base.hasPermission(a, permission);
            }
        };
    }
}

