/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class AllContainersRunningPodWatcher
implements Watcher<Pod> {
    private static final Logger LOGGER = Logger.getLogger(AllContainersRunningPodWatcher.class.getName());
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicReference<Pod> reference = new AtomicReference();
    private Pod pod;
    private KubernetesClient client;

    public AllContainersRunningPodWatcher(KubernetesClient client, Pod pod) {
        this.client = client;
        this.pod = pod;
        this.updateState(pod);
    }

    public void eventReceived(Watcher.Action action, Pod pod) {
        LOGGER.log(Level.FINEST, "[{0}] {1}", new Object[]{action, pod.getMetadata().getName()});
        switch (action) {
            case MODIFIED: {
                this.updateState(pod);
                break;
            }
        }
    }

    private void updateState(Pod pod) {
        if (this.areAllContainersRunning(pod)) {
            LOGGER.log(Level.FINE, "All containers are running for pod {0}", new Object[]{pod.getMetadata().getName()});
            this.reference.set(pod);
            this.latch.countDown();
        }
    }

    boolean areAllContainersRunning(Pod pod) {
        PodStatus podStatus = pod.getStatus();
        if (podStatus == null) {
            return false;
        }
        List containerStatuses = pod.getStatus().getContainerStatuses();
        if (containerStatuses.isEmpty()) {
            return false;
        }
        for (ContainerStatus containerStatus : containerStatuses) {
            if (containerStatus == null) continue;
            if (containerStatus.getState().getWaiting() != null) {
                return false;
            }
            if (containerStatus.getState().getTerminated() != null) {
                return false;
            }
            if (containerStatus.getReady().booleanValue()) continue;
            return false;
        }
        return true;
    }

    private List<ContainerStatus> getTerminatedContainers(Pod pod) {
        PodStatus podStatus = pod.getStatus();
        if (podStatus == null) {
            return Collections.emptyList();
        }
        List containerStatuses = pod.getStatus().getContainerStatuses();
        if (containerStatuses.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ContainerStatus> result = new ArrayList<ContainerStatus>();
        for (ContainerStatus containerStatus : containerStatuses) {
            if (containerStatus == null || containerStatus.getState().getTerminated() == null) continue;
            result.add(containerStatus);
        }
        return result;
    }

    public void onClose(KubernetesClientException cause) {
    }

    public Pod await(long amount, TimeUnit timeUnit) {
        long started = System.currentTimeMillis();
        long alreadySpent = System.currentTimeMillis() - started;
        long remaining = timeUnit.toMillis(amount) - alreadySpent;
        if (remaining <= 0L) {
            return this.periodicAwait(0, System.currentTimeMillis(), 0L, 0L);
        }
        try {
            return this.periodicAwait(10, System.currentTimeMillis(), Math.max(remaining / 10L, 1000L), remaining);
        }
        catch (KubernetesClientTimeoutException e) {
            throw new KubernetesClientTimeoutException((HasMetadata)this.pod, amount, timeUnit);
        }
    }

    private Pod awaitWatcher(long amount, TimeUnit timeUnit) {
        try {
            if (this.latch.await(amount, timeUnit)) {
                return this.reference.get();
            }
            throw new KubernetesClientTimeoutException((HasMetadata)this.pod, amount, timeUnit);
        }
        catch (InterruptedException e) {
            throw new KubernetesClientTimeoutException((HasMetadata)this.pod, amount, timeUnit);
        }
    }

    private Pod periodicAwait(int i, long started, long interval, long amount) {
        Pod pod = (Pod)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.pod.getMetadata().getNamespace())).withName(this.pod.getMetadata().getName())).get();
        if (pod == null) {
            throw new IllegalStateException(String.format("Pod is no longer available: %s/%s", this.pod.getMetadata().getNamespace(), this.pod.getMetadata().getName()));
        }
        LOGGER.finest(() -> "Updating pod for " + this.pod.getMetadata().getNamespace() + "/" + this.pod.getMetadata().getName() + " : " + pod);
        this.pod = pod;
        List<ContainerStatus> terminatedContainers = this.getTerminatedContainers(pod);
        if (!terminatedContainers.isEmpty()) {
            throw new IllegalStateException(String.format("Pod has terminated containers: %s/%s (%s)", this.pod.getMetadata().getNamespace(), this.pod.getMetadata().getName(), terminatedContainers.stream().map(ContainerStatus::getName).collect(Collectors.joining(", "))));
        }
        if (this.areAllContainersRunning(pod)) {
            return pod;
        }
        try {
            return this.awaitWatcher(interval, TimeUnit.MILLISECONDS);
        }
        catch (KubernetesClientTimeoutException e) {
            if (i <= 0) {
                throw e;
            }
            long remaining = started + amount - System.currentTimeMillis();
            long next = Math.max(0L, Math.min(remaining, interval));
            return this.periodicAwait(i - 1, started, next, amount);
        }
    }

    public PodStatus getPodStatus() {
        return this.pod.getStatus();
    }
}

