/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.volumes;

import hudson.Extension;
import hudson.model.Descriptor;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import org.csanchez.jenkins.plugins.kubernetes.volumes.PodVolume;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class ConfigMapVolume
extends PodVolume {
    private String mountPath;
    private String configMapName;

    @DataBoundConstructor
    public ConfigMapVolume(String mountPath, String configMapName) {
        this.mountPath = mountPath;
        this.configMapName = configMapName;
    }

    @Override
    public Volume buildVolume(String volumeName) {
        return ((VolumeBuilder)((VolumeFluent.ConfigMapNested)((VolumeBuilder)new VolumeBuilder().withName(volumeName)).withNewConfigMap().withName(this.getConfigMapName())).and()).build();
    }

    public String getConfigMapName() {
        return this.configMapName;
    }

    @Override
    public String getMountPath() {
        return this.mountPath;
    }

    @Extension
    @Symbol(value={"configMapVolume"})
    public static class DescriptorImpl
    extends Descriptor<PodVolume> {
        public String getDisplayName() {
            return "Config Map Volume";
        }
    }
}

