/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.model.Run;
import hudson.slaves.Cloud;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.commons.lang.RandomStringUtils;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.Messages;
import org.csanchez.jenkins.plugins.kubernetes.PodImagePullSecret;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateUtils;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.NamespaceAction;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.PodTemplateAction;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.PodTemplateStep;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class PodTemplateStepExecution
extends AbstractStepExecutionImpl {
    private static final Logger LOGGER = Logger.getLogger(PodTemplateStepExecution.class.getName());
    private static final long serialVersionUID = -6139090518333729333L;
    private static final transient String NAME_FORMAT = "%s-%s";
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="not needed on deserialization")
    private final transient PodTemplateStep step;
    private final String cloudName;
    private PodTemplate newTemplate = null;

    PodTemplateStepExecution(PodTemplateStep step, StepContext context) {
        super(context);
        this.step = step;
        this.cloudName = step.getCloud();
    }

    public boolean start() throws Exception {
        Cloud cloud = Jenkins.getInstance().getCloud(this.cloudName);
        if (cloud == null) {
            throw new AbortException(String.format("Cloud does not exist: %s", this.cloudName));
        }
        if (!(cloud instanceof KubernetesCloud)) {
            throw new AbortException(String.format("Cloud is not a Kubernetes cloud: %s (%s)", this.cloudName, cloud.getClass().getName()));
        }
        KubernetesCloud kubernetesCloud = (KubernetesCloud)cloud;
        Run run = (Run)this.getContext().get(Run.class);
        PodTemplateAction podTemplateAction = (PodTemplateAction)run.getAction(PodTemplateAction.class);
        NamespaceAction namespaceAction = (NamespaceAction)run.getAction(NamespaceAction.class);
        String parentTemplates = podTemplateAction != null ? podTemplateAction.getParentTemplates() : null;
        String randString = RandomStringUtils.random((int)5, (String)"bcdfghjklmnpqrstvwxz0123456789");
        String name = String.format(NAME_FORMAT, this.step.getName(), randString);
        String namespace = this.checkNamespace(kubernetesCloud, namespaceAction);
        this.newTemplate = new PodTemplate();
        this.newTemplate.setName(name);
        this.newTemplate.setNamespace(namespace);
        this.newTemplate.setInheritFrom(!Strings.isNullOrEmpty((String)parentTemplates) ? parentTemplates : this.step.getInheritFrom());
        this.newTemplate.setInstanceCap(this.step.getInstanceCap());
        this.newTemplate.setIdleMinutes(this.step.getIdleMinutes());
        this.newTemplate.setSlaveConnectTimeout(this.step.getSlaveConnectTimeout());
        this.newTemplate.setLabel(this.step.getLabel());
        this.newTemplate.setEnvVars(this.step.getEnvVars());
        this.newTemplate.setVolumes(this.step.getVolumes());
        this.newTemplate.setCustomWorkspaceVolumeEnabled(this.step.getWorkspaceVolume() != null);
        this.newTemplate.setWorkspaceVolume(this.step.getWorkspaceVolume());
        this.newTemplate.setContainers(this.step.getContainers());
        this.newTemplate.setNodeSelector(this.step.getNodeSelector());
        this.newTemplate.setNodeUsageMode(this.step.getNodeUsageMode());
        this.newTemplate.setServiceAccount(this.step.getServiceAccount());
        this.newTemplate.setAnnotations(this.step.getAnnotations());
        this.newTemplate.setImagePullSecrets(this.step.getImagePullSecrets().stream().map(x -> new PodImagePullSecret((String)x)).collect(Collectors.toList()));
        this.newTemplate.setYaml(this.step.getYaml());
        if (this.step.getActiveDeadlineSeconds() != 0) {
            this.newTemplate.setActiveDeadlineSeconds(this.step.getActiveDeadlineSeconds());
        }
        for (ContainerTemplate container : this.newTemplate.getContainers()) {
            if (PodTemplateUtils.validateContainerName(container.getName())) continue;
            throw new AbortException(Messages.RFC1123_error(container.getName()));
        }
        Collection<String> errors = PodTemplateUtils.validateYamlContainerNames(this.newTemplate.getYaml());
        if (!errors.isEmpty()) {
            throw new AbortException(Messages.RFC1123_error(String.join((CharSequence)", ", errors)));
        }
        if (!PodTemplateUtils.validateLabel(this.newTemplate.getLabel())) {
            throw new AbortException(Messages.label_error(this.newTemplate.getLabel()));
        }
        kubernetesCloud.addDynamicTemplate(this.newTemplate);
        this.getContext().newBodyInvoker().withContext((Object)this.step).withCallback((BodyExecutionCallback)new PodTemplateCallback(this.newTemplate)).start();
        PodTemplateAction.push(run, name);
        NamespaceAction.push(run, namespace);
        return false;
    }

    public void stop(Throwable cause) throws Exception {
        new PodTemplateAction((Run)this.getContext().get(Run.class)).pop();
    }

    private String checkNamespace(KubernetesCloud kubernetesCloud, @CheckForNull NamespaceAction namespaceAction) {
        String namespace = null;
        namespace = !Strings.isNullOrEmpty((String)this.step.getNamespace()) ? this.step.getNamespace() : (namespaceAction != null && !Strings.isNullOrEmpty((String)namespaceAction.getNamespace()) ? namespaceAction.getNamespace() : kubernetesCloud.getNamespace());
        return namespace;
    }

    public void onResume() {
        super.onResume();
        Cloud cloud = Jenkins.getInstance().getCloud(this.cloudName);
        if (cloud == null) {
            throw new RuntimeException(String.format("Cloud does not exist: %s", this.cloudName));
        }
        if (!(cloud instanceof KubernetesCloud)) {
            throw new RuntimeException(String.format("Cloud is not a Kubernetes cloud: %s (%s)", this.cloudName, cloud.getClass().getName()));
        }
        KubernetesCloud kubernetesCloud = (KubernetesCloud)cloud;
        kubernetesCloud.addDynamicTemplate(this.newTemplate);
    }

    private class PodTemplateCallback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = 6043919968776851324L;
        private final PodTemplate podTemplate;

        private PodTemplateCallback(PodTemplate podTemplate) {
            this.podTemplate = podTemplate;
        }

        protected void finished(StepContext context) throws Exception {
            Cloud cloud = Jenkins.getInstance().getCloud(PodTemplateStepExecution.this.cloudName);
            if (cloud == null) {
                LOGGER.log(Level.WARNING, "Cloud {0} no longer exists, cannot delete pod template {1}", new Object[]{PodTemplateStepExecution.this.cloudName, this.podTemplate.getName()});
                return;
            }
            if (cloud instanceof KubernetesCloud) {
                LOGGER.log(Level.INFO, "Removing pod template and deleting pod {1} from cloud {0}", new Object[]{cloud.name, this.podTemplate.getName()});
                KubernetesCloud kubernetesCloud = (KubernetesCloud)cloud;
                kubernetesCloud.removeDynamicTemplate(this.podTemplate);
                KubernetesClient client = kubernetesCloud.connect();
                Boolean deleted = (Boolean)((PodResource)client.pods().withName(this.podTemplate.getName())).delete();
                if (!Boolean.TRUE.equals(deleted)) {
                    LOGGER.log(Level.WARNING, "Failed to delete pod for agent {0}/{1}: not found", new String[]{client.getNamespace(), this.podTemplate.getName()});
                    return;
                }
            } else {
                LOGGER.log(Level.WARNING, "Cloud is not a KubernetesCloud: {0} {1}", new String[]{cloud.name, cloud.getClass().getName()});
            }
        }
    }
}

