/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.PrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TimeTailPrettyLoggable;
import java.io.Closeable;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.ContainerLogStep;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.KubernetesNodeContext;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.Resources;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public class ContainerLogStepExecution
extends SynchronousNonBlockingStepExecution<String> {
    private static final long serialVersionUID = 5588861066775717487L;
    private static final transient Logger LOGGER = Logger.getLogger(ContainerLogStepExecution.class.getName());
    private final ContainerLogStep step;
    private transient KubernetesClient client;

    ContainerLogStepExecution(ContainerLogStep step, StepContext context) {
        super(context);
        this.step = step;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrintStream logger() {
        TaskListener l = null;
        StepContext context = this.getContext();
        try {
            l = (TaskListener)context.get(TaskListener.class);
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, "Failed to find TaskListener in context");
        }
        finally {
            if (l == null) {
                l = new LogTaskListener(LOGGER, Level.FINE);
            }
        }
        return l.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String run() throws Exception {
        String string;
        String log;
        String podName;
        String containerName;
        block8: {
            boolean returnLog = this.step.isReturnLog();
            containerName = this.step.getName();
            int tailingLines = this.step.getTailingLines();
            int sinceSeconds = this.step.getSinceSeconds();
            int limitBytes = this.step.getLimitBytes();
            LOGGER.log(Level.FINE, "Starting containerLog step.");
            KubernetesNodeContext nodeContext = new KubernetesNodeContext(this.getContext());
            this.client = nodeContext.connectToCloud();
            podName = nodeContext.getPodName();
            ContainerResource container = (ContainerResource)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(nodeContext.getNamespace())).withName(podName)).inContainer((Object)containerName);
            ContainerResource limited = limitBytes > 0 ? (TimeTailPrettyLoggable)container.limitBytes(limitBytes) : container;
            ContainerResource since = sinceSeconds > 0 ? (TailPrettyLoggable)limited.sinceSeconds(sinceSeconds) : limited;
            ContainerResource tailed = tailingLines > 0 ? (PrettyLoggable)since.tailingLines(tailingLines) : since;
            log = (String)tailed.getLog();
            if (!returnLog) break block8;
            String string2 = log;
            Resources.closeQuietly(this.getContext(), new Closeable[]{this.client});
            return string2;
        }
        try {
            this.logger().println("> start log of container '" + containerName + "' in pod '" + podName + "'");
            this.logger().print(log);
            if (log.length() > 0 && log.charAt(log.length() - 1) != '\n') {
                this.logger().println();
            }
            this.logger().println("> end log of container '" + containerName + "' in pod '" + podName + "'");
            string = "";
        }
        catch (InterruptedException e) {
            this.logger().println("Interrupted while getting logs of container");
            LOGGER.log(Level.FINE, "interrupted while getting logs of container {1}", containerName);
            podName = "";
            Resources.closeQuietly(this.getContext(), new Closeable[]{this.client});
            return podName;
        }
        catch (Exception e2) {
            String message = "Failed to get logs for container";
            this.logger().println(message);
            LOGGER.log(Level.WARNING, message, e2);
            String string3 = "";
            {
                catch (Throwable throwable) {
                    Resources.closeQuietly(this.getContext(), new Closeable[]{this.client});
                    throw throwable;
                }
            }
            Resources.closeQuietly(this.getContext(), new Closeable[]{this.client});
            return string3;
        }
        Resources.closeQuietly(this.getContext(), new Closeable[]{this.client});
        return string;
    }

    public void stop(Throwable cause) throws Exception {
        LOGGER.log(Level.FINE, "Stopping container log step.");
        try {
            super.stop(cause);
        }
        catch (Throwable throwable) {
            Resources.closeQuietly(this.getContext(), new Closeable[]{this.client});
            throw throwable;
        }
        Resources.closeQuietly(this.getContext(), new Closeable[]{this.client});
    }
}

