/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Saveable;
import hudson.model.labels.LabelAtom;
import hudson.slaves.NodeProperty;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.csanchez.jenkins.plugins.kubernetes.PodAnnotation;
import org.csanchez.jenkins.plugins.kubernetes.PodImagePullSecret;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateBuilder;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateToolLocation;
import org.csanchez.jenkins.plugins.kubernetes.model.TemplateEnvVar;
import org.csanchez.jenkins.plugins.kubernetes.volumes.PodVolume;
import org.csanchez.jenkins.plugins.kubernetes.volumes.workspace.WorkspaceVolume;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PodTemplate
extends AbstractDescribableImpl<PodTemplate>
implements Serializable,
Saveable {
    private static final long serialVersionUID = 3285310269140845583L;
    private static final String FALLBACK_ARGUMENTS = "${computer.jnlpmac} ${computer.name}";
    private static final String DEFAULT_ID = "jenkins/slave-default";
    private static final Logger LOGGER = Logger.getLogger(PodTemplate.class.getName());
    public static final int DEFAULT_SLAVE_JENKINS_CONNECTION_TIMEOUT = 100;
    private String inheritFrom;
    private String name;
    private String namespace;
    private String image;
    private boolean privileged;
    private boolean capOnlyOnAlivePods;
    private boolean alwaysPullImage;
    private String command;
    private String args;
    private String remoteFs;
    private int instanceCap = Integer.MAX_VALUE;
    private int slaveConnectTimeout = 100;
    private int idleMinutes;
    private int activeDeadlineSeconds;
    private String label;
    private String serviceAccount;
    private String nodeSelector;
    private Node.Mode nodeUsageMode;
    private String resourceRequestCpu;
    private String resourceRequestMemory;
    private String resourceLimitCpu;
    private String resourceLimitMemory;
    private boolean customWorkspaceVolumeEnabled;
    private WorkspaceVolume workspaceVolume;
    private final List<PodVolume> volumes = new ArrayList<PodVolume>();
    private List<ContainerTemplate> containers = new ArrayList<ContainerTemplate>();
    private List<TemplateEnvVar> envVars = new ArrayList<TemplateEnvVar>();
    private List<PodAnnotation> annotations = new ArrayList<PodAnnotation>();
    private List<PodImagePullSecret> imagePullSecrets = new ArrayList<PodImagePullSecret>();
    private PodTemplateToolLocation nodeProperties;
    private String yaml;

    @DataBoundConstructor
    public PodTemplate() {
    }

    public PodTemplate(PodTemplate from) {
        this.setAnnotations(from.getAnnotations());
        this.setContainers(from.getContainers());
        this.setImagePullSecrets(from.getImagePullSecrets());
        this.setInstanceCap(from.getInstanceCap());
        this.setLabel(from.getLabel());
        this.setName(from.getName());
        this.setNamespace(from.getNamespace());
        this.setInheritFrom(from.getInheritFrom());
        this.setNodeSelector(from.getNodeSelector());
        this.setNodeUsageMode(from.getNodeUsageMode());
        this.setServiceAccount(from.getServiceAccount());
        this.setSlaveConnectTimeout(from.getSlaveConnectTimeout());
        this.setActiveDeadlineSeconds(from.getActiveDeadlineSeconds());
        this.setVolumes(from.getVolumes());
        this.setWorkspaceVolume(from.getWorkspaceVolume());
        this.setYaml(from.getYaml());
        this.setNodeProperties((List<? extends NodeProperty<?>>)((Object)from.getNodeProperties()));
    }

    @Deprecated
    public PodTemplate(String image, List<? extends PodVolume> volumes) {
        this(null, image, volumes);
    }

    @Deprecated
    PodTemplate(String name, String image, List<? extends PodVolume> volumes) {
        this(name, volumes, Collections.emptyList());
        if (image != null) {
            this.getContainers().add(new ContainerTemplate(name, image));
        }
    }

    @Restricted(value={NoExternalUse.class})
    PodTemplate(String name, List<? extends PodVolume> volumes, List<? extends ContainerTemplate> containers) {
        this.name = name;
        this.volumes.addAll(volumes);
        this.containers.addAll(containers);
    }

    private Optional<ContainerTemplate> getFirstContainer() {
        return Optional.ofNullable(this.getContainers().isEmpty() ? null : this.getContainers().get(0));
    }

    public String getInheritFrom() {
        return this.inheritFrom;
    }

    @DataBoundSetter
    public void setInheritFrom(String inheritFrom) {
        this.inheritFrom = inheritFrom;
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @DataBoundSetter
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Deprecated
    public String getImage() {
        return this.getFirstContainer().map(ContainerTemplate::getImage).orElse(null);
    }

    @Deprecated
    @DataBoundSetter
    public void setCommand(String command) {
        this.getFirstContainer().ifPresent(i -> i.setCommand(command));
    }

    @Deprecated
    public String getCommand() {
        return this.getFirstContainer().map(ContainerTemplate::getCommand).orElse(null);
    }

    @Deprecated
    @DataBoundSetter
    public void setArgs(String args) {
        this.getFirstContainer().ifPresent(i -> i.setArgs(args));
    }

    @Deprecated
    public String getArgs() {
        return this.getFirstContainer().map(ContainerTemplate::getArgs).orElse(null);
    }

    public String getDisplayName() {
        return "Kubernetes Pod Template";
    }

    @DataBoundSetter
    @Deprecated
    public void setRemoteFs(String remoteFs) {
        this.getFirstContainer().ifPresent(i -> i.setWorkingDir(remoteFs));
    }

    @Deprecated
    public String getRemoteFs() {
        return this.getFirstContainer().map(ContainerTemplate::getWorkingDir).orElse(null);
    }

    public void setInstanceCap(int instanceCap) {
        this.instanceCap = instanceCap < 0 ? Integer.MAX_VALUE : instanceCap;
    }

    public int getInstanceCap() {
        return this.instanceCap;
    }

    public void setSlaveConnectTimeout(int slaveConnectTimeout) {
        if (slaveConnectTimeout <= 0) {
            LOGGER.log(Level.WARNING, "Agent -> Jenkins connection timeout cannot be <= 0. Falling back to the default value: 100");
            this.slaveConnectTimeout = 100;
        } else {
            this.slaveConnectTimeout = slaveConnectTimeout;
        }
    }

    public int getSlaveConnectTimeout() {
        if (this.slaveConnectTimeout == 0) {
            return 100;
        }
        return this.slaveConnectTimeout;
    }

    @DataBoundSetter
    public void setInstanceCapStr(String instanceCapStr) {
        if (StringUtils.isBlank((String)instanceCapStr)) {
            this.setInstanceCap(Integer.MAX_VALUE);
        } else {
            this.setInstanceCap(Integer.parseInt(instanceCapStr));
        }
    }

    public String getInstanceCapStr() {
        if (this.getInstanceCap() == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.instanceCap);
    }

    @DataBoundSetter
    public void setSlaveConnectTimeoutStr(String slaveConnectTimeoutStr) {
        if (StringUtils.isBlank((String)slaveConnectTimeoutStr)) {
            this.setSlaveConnectTimeout(100);
        } else {
            this.setSlaveConnectTimeout(Integer.parseInt(slaveConnectTimeoutStr));
        }
    }

    public String getSlaveConnectTimeoutStr() {
        return String.valueOf(this.slaveConnectTimeout);
    }

    public void setIdleMinutes(int i) {
        this.idleMinutes = i;
    }

    public int getIdleMinutes() {
        return this.idleMinutes;
    }

    public void setActiveDeadlineSeconds(int i) {
        this.activeDeadlineSeconds = i;
    }

    public int getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    @DataBoundSetter
    public void setIdleMinutesStr(String idleMinutes) {
        if (StringUtils.isBlank((String)idleMinutes)) {
            this.setIdleMinutes(0);
        } else {
            this.setIdleMinutes(Integer.parseInt(idleMinutes));
        }
    }

    public String getIdleMinutesStr() {
        if (this.getIdleMinutes() == 0) {
            return "";
        }
        return String.valueOf(this.idleMinutes);
    }

    @DataBoundSetter
    public void setActiveDeadlineSecondsStr(String activeDeadlineSeconds) {
        if (StringUtils.isBlank((String)activeDeadlineSeconds)) {
            this.setActiveDeadlineSeconds(0);
        } else {
            this.setActiveDeadlineSeconds(Integer.parseInt(activeDeadlineSeconds));
        }
    }

    public String getActiveDeadlineSecondsStr() {
        if (this.getActiveDeadlineSeconds() == 0) {
            return "";
        }
        return String.valueOf(this.activeDeadlineSeconds);
    }

    public Set<LabelAtom> getLabelSet() {
        return Label.parse((String)this.label);
    }

    public Map<String, String> getLabelsMap() {
        Set<LabelAtom> labelSet = this.getLabelSet();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (!labelSet.isEmpty()) {
            for (LabelAtom label : labelSet) {
                builder.put((Object)(label == null ? DEFAULT_ID : "jenkins/" + label.getName()), (Object)"true");
            }
        }
        return builder.build();
    }

    @DataBoundSetter
    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    @DataBoundSetter
    public void setNodeSelector(String nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public String getNodeSelector() {
        return this.nodeSelector;
    }

    @DataBoundSetter
    public void setNodeUsageMode(Node.Mode nodeUsageMode) {
        this.nodeUsageMode = nodeUsageMode;
    }

    @DataBoundSetter
    public void setNodeUsageMode(String nodeUsageMode) {
        this.nodeUsageMode = Node.Mode.valueOf((String)nodeUsageMode);
    }

    public Node.Mode getNodeUsageMode() {
        return this.nodeUsageMode;
    }

    @Deprecated
    @DataBoundSetter
    public void setPrivileged(boolean privileged) {
        this.getFirstContainer().ifPresent(i -> i.setPrivileged(privileged));
    }

    @Deprecated
    public boolean isPrivileged() {
        return this.getFirstContainer().map(ContainerTemplate::isPrivileged).orElse(false);
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    @DataBoundSetter
    public void setServiceAccount(String serviceAccount) {
        this.serviceAccount = Util.fixEmpty((String)serviceAccount);
    }

    @Deprecated
    @DataBoundSetter
    public void setAlwaysPullImage(boolean alwaysPullImage) {
        this.getFirstContainer().ifPresent(i -> i.setAlwaysPullImage(alwaysPullImage));
    }

    @Deprecated
    public boolean isAlwaysPullImage() {
        return this.getFirstContainer().map(ContainerTemplate::isAlwaysPullImage).orElse(false);
    }

    @DataBoundSetter
    public void setCapOnlyOnAlivePods(boolean capOnlyOnAlivePods) {
        this.capOnlyOnAlivePods = capOnlyOnAlivePods;
    }

    public boolean isCapOnlyOnAlivePods() {
        return this.capOnlyOnAlivePods;
    }

    public List<TemplateEnvVar> getEnvVars() {
        if (this.envVars == null) {
            return Collections.emptyList();
        }
        return this.envVars;
    }

    public void addEnvVars(List<TemplateEnvVar> envVars) {
        if (envVars != null) {
            this.envVars.addAll(envVars);
        }
    }

    @DataBoundSetter
    public void setEnvVars(List<TemplateEnvVar> envVars) {
        if (envVars != null) {
            this.envVars.clear();
            this.addEnvVars(envVars);
        }
    }

    public List<PodAnnotation> getAnnotations() {
        if (this.annotations == null) {
            return Collections.emptyList();
        }
        return this.annotations;
    }

    public void addAnnotations(List<PodAnnotation> annotations) {
        this.annotations.addAll(annotations);
    }

    @DataBoundSetter
    public void setAnnotations(List<PodAnnotation> annotations) {
        if (annotations != null) {
            this.annotations = new ArrayList<PodAnnotation>();
            this.addAnnotations(annotations);
        }
    }

    public List<PodImagePullSecret> getImagePullSecrets() {
        return this.imagePullSecrets == null ? Collections.emptyList() : this.imagePullSecrets;
    }

    public void addImagePullSecrets(List<PodImagePullSecret> imagePullSecrets) {
        this.imagePullSecrets.addAll(imagePullSecrets);
    }

    @DataBoundSetter
    public void setImagePullSecrets(List<PodImagePullSecret> imagePullSecrets) {
        if (imagePullSecrets != null) {
            this.imagePullSecrets.clear();
            this.addImagePullSecrets(imagePullSecrets);
        }
    }

    @DataBoundSetter
    public void setNodeProperties(List<? extends NodeProperty<?>> properties) {
        this.getNodeProperties().clear();
        this.getNodeProperties().addAll(properties);
    }

    @NonNull
    public PodTemplateToolLocation getNodeProperties() {
        if (this.nodeProperties == null) {
            this.nodeProperties = new PodTemplateToolLocation(this);
        }
        return this.nodeProperties;
    }

    @Deprecated
    public String getResourceRequestMemory() {
        return this.getFirstContainer().map(ContainerTemplate::getResourceRequestMemory).orElse(null);
    }

    @Deprecated
    @DataBoundSetter
    public void setResourceRequestMemory(String resourceRequestMemory) {
        this.getFirstContainer().ifPresent(i -> i.setResourceRequestMemory(resourceRequestMemory));
    }

    @Deprecated
    public String getResourceLimitCpu() {
        return this.getFirstContainer().map(ContainerTemplate::getResourceLimitCpu).orElse(null);
    }

    @Deprecated
    @DataBoundSetter
    public void setResourceLimitCpu(String resourceLimitCpu) {
        this.getFirstContainer().ifPresent(i -> i.setResourceLimitCpu(resourceLimitCpu));
    }

    @Deprecated
    public String getResourceLimitMemory() {
        return this.getFirstContainer().map(ContainerTemplate::getResourceLimitMemory).orElse(null);
    }

    @Deprecated
    @DataBoundSetter
    public void setResourceLimitMemory(String resourceLimitMemory) {
        this.getFirstContainer().ifPresent(i -> i.setResourceLimitMemory(resourceLimitMemory));
    }

    @Deprecated
    public String getResourceRequestCpu() {
        return this.getFirstContainer().map(ContainerTemplate::getResourceRequestCpu).orElse(null);
    }

    @Deprecated
    @DataBoundSetter
    public void setResourceRequestCpu(String resourceRequestCpu) {
        this.getFirstContainer().ifPresent(i -> i.setResourceRequestCpu(resourceRequestCpu));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DataBoundSetter
    public void setVolumes(@Nonnull List<PodVolume> items) {
        List<PodVolume> list = this.volumes;
        synchronized (list) {
            this.volumes.clear();
            this.volumes.addAll(items);
        }
    }

    @Nonnull
    public List<PodVolume> getVolumes() {
        if (this.volumes == null) {
            return Collections.emptyList();
        }
        return this.volumes;
    }

    public boolean isCustomWorkspaceVolumeEnabled() {
        return this.customWorkspaceVolumeEnabled;
    }

    @DataBoundSetter
    public void setCustomWorkspaceVolumeEnabled(boolean customWorkspaceVolumeEnabled) {
        this.customWorkspaceVolumeEnabled = customWorkspaceVolumeEnabled;
    }

    public WorkspaceVolume getWorkspaceVolume() {
        return this.workspaceVolume;
    }

    @DataBoundSetter
    public void setWorkspaceVolume(WorkspaceVolume workspaceVolume) {
        this.workspaceVolume = workspaceVolume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DataBoundSetter
    public void setContainers(@Nonnull List<ContainerTemplate> items) {
        List<ContainerTemplate> list = this.containers;
        synchronized (list) {
            this.containers.clear();
            this.containers.addAll(items);
        }
    }

    @Nonnull
    public List<ContainerTemplate> getContainers() {
        if (this.containers == null) {
            return Collections.emptyList();
        }
        return this.containers;
    }

    public String getYaml() {
        return this.yaml;
    }

    @DataBoundSetter
    public void setYaml(String yaml) {
        this.yaml = yaml;
    }

    protected Object readResolve() {
        if (this.containers == null) {
            this.containers = new ArrayList<ContainerTemplate>();
            ContainerTemplate containerTemplate = new ContainerTemplate("jnlp", this.image);
            containerTemplate.setCommand(this.command);
            containerTemplate.setArgs(Strings.isNullOrEmpty((String)this.args) ? FALLBACK_ARGUMENTS : this.args);
            containerTemplate.setPrivileged(this.privileged);
            containerTemplate.setAlwaysPullImage(this.alwaysPullImage);
            containerTemplate.setEnvVars(this.envVars);
            containerTemplate.setResourceRequestMemory(this.resourceRequestMemory);
            containerTemplate.setResourceLimitCpu(this.resourceLimitCpu);
            containerTemplate.setResourceLimitMemory(this.resourceLimitMemory);
            containerTemplate.setResourceRequestCpu(this.resourceRequestCpu);
            containerTemplate.setWorkingDir(this.remoteFs);
            this.containers.add(containerTemplate);
        }
        if (this.annotations == null) {
            this.annotations = new ArrayList<PodAnnotation>();
        }
        return this;
    }

    public Pod build(KubernetesClient client, KubernetesSlave slave) {
        return new PodTemplateBuilder(this).withSlave(slave).build();
    }

    public String getDescriptionForLogging() {
        return String.format("Agent specification [%s] (%s): %n%s", this.getDisplayName(), this.getLabel(), this.getContainersDescriptionForLogging());
    }

    private String getContainersDescriptionForLogging() {
        List<ContainerTemplate> containers = this.getContainers();
        StringBuilder sb = new StringBuilder();
        for (ContainerTemplate ct : containers) {
            sb.append("* [").append(ct.getName()).append("] ").append(ct.getImage());
            StringBuilder optional = new StringBuilder();
            this.optionalField(optional, "resourceRequestCpu", ct.getResourceRequestCpu());
            this.optionalField(optional, "resourceRequestMemory", ct.getResourceRequestMemory());
            this.optionalField(optional, "resourceLimitCpu", ct.getResourceLimitCpu());
            this.optionalField(optional, "resourceLimitMemory", ct.getResourceLimitMemory());
            if (optional.length() > 0) {
                sb.append("(").append((CharSequence)optional).append(")");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private void optionalField(StringBuilder builder, String label, String value) {
        if (value != null) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(label).append(": ").append(value);
        }
    }

    public void save() {
    }

    public String toString() {
        return "PodTemplate{" + (this.inheritFrom == null ? "" : "inheritFrom='" + this.inheritFrom + '\'') + (this.name == null ? "" : ", name='" + this.name + '\'') + (this.namespace == null ? "" : ", namespace='" + this.namespace + '\'') + (this.image == null ? "" : ", image='" + this.image + '\'') + (!this.privileged ? "" : ", privileged=" + this.privileged) + (!this.alwaysPullImage ? "" : ", alwaysPullImage=" + this.alwaysPullImage) + (this.command == null ? "" : ", command='" + this.command + '\'') + (this.args == null ? "" : ", args='" + this.args + '\'') + (this.remoteFs == null ? "" : ", remoteFs='" + this.remoteFs + '\'') + (this.instanceCap == Integer.MAX_VALUE ? "" : ", instanceCap=" + this.instanceCap) + (this.slaveConnectTimeout == 100 ? "" : ", slaveConnectTimeout=" + this.slaveConnectTimeout) + (this.idleMinutes == 0 ? "" : ", idleMinutes=" + this.idleMinutes) + (this.activeDeadlineSeconds == 0 ? "" : ", activeDeadlineSeconds=" + this.activeDeadlineSeconds) + (this.label == null ? "" : ", label='" + this.label + '\'') + (this.serviceAccount == null ? "" : ", serviceAccount='" + this.serviceAccount + '\'') + (this.nodeSelector == null ? "" : ", nodeSelector='" + this.nodeSelector + '\'') + (this.nodeUsageMode == null ? "" : ", nodeUsageMode=" + this.nodeUsageMode) + (this.resourceRequestCpu == null ? "" : ", resourceRequestCpu='" + this.resourceRequestCpu + '\'') + (this.resourceRequestMemory == null ? "" : ", resourceRequestMemory='" + this.resourceRequestMemory + '\'') + (this.resourceLimitCpu == null ? "" : ", resourceLimitCpu='" + this.resourceLimitCpu + '\'') + (this.resourceLimitMemory == null ? "" : ", resourceLimitMemory='" + this.resourceLimitMemory + '\'') + (!this.customWorkspaceVolumeEnabled ? "" : ", customWorkspaceVolumeEnabled=" + this.customWorkspaceVolumeEnabled) + (this.workspaceVolume == null ? "" : ", workspaceVolume=" + this.workspaceVolume) + (this.volumes == null || this.volumes.isEmpty() ? "" : ", volumes=" + this.volumes) + (this.containers == null || this.containers.isEmpty() ? "" : ", containers=" + this.containers) + (this.envVars == null || this.envVars.isEmpty() ? "" : ", envVars=" + this.envVars) + (this.annotations == null || this.annotations.isEmpty() ? "" : ", annotations=" + this.annotations) + (this.imagePullSecrets == null || this.imagePullSecrets.isEmpty() ? "" : ", imagePullSecrets=" + this.imagePullSecrets) + (this.nodeProperties == null || this.nodeProperties.isEmpty() ? "" : ", nodeProperties=" + this.nodeProperties) + (this.yaml == null ? "" : ", yaml=" + this.yaml) + '}';
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<PodTemplate> {
        public String getDisplayName() {
            return "Kubernetes Pod Template";
        }

        @Restricted(value={DoNotUse.class})
        public List<? extends Descriptor> getEnvVarsDescriptors() {
            return DescriptorVisibilityFilter.apply(null, (Iterable)Jenkins.getInstance().getDescriptorList(TemplateEnvVar.class));
        }
    }
}

