/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.Cloud;
import hudson.slaves.CloudRetentionStrategy;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.OfflineCause;
import hudson.slaves.RetentionStrategy;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesComputer;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesLauncher;
import org.csanchez.jenkins.plugins.kubernetes.Messages;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.jenkinsci.plugins.durabletask.executors.OnceRetentionStrategy;
import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.DataBoundConstructor;

public class KubernetesSlave
extends AbstractCloudSlave {
    private static final Logger LOGGER = Logger.getLogger(KubernetesSlave.class.getName());
    private static final Integer DISCONNECTION_TIMEOUT = Integer.getInteger(KubernetesSlave.class.getName() + ".disconnectionTimeout", 5);
    private static final long serialVersionUID = -8642936855413034232L;
    private static final String DEFAULT_AGENT_PREFIX = "jenkins-agent";
    private static final ResourceBundleHolder HOLDER = ResourceBundleHolder.get(Messages.class);
    private final String cloudName;
    private final String namespace;
    private final PodTemplate template;
    private transient Set<Queue.Executable> executables = new HashSet<Queue.Executable>();

    public PodTemplate getTemplate() {
        return this.template;
    }

    @Deprecated
    public KubernetesSlave(PodTemplate template, String nodeDescription, KubernetesCloud cloud, String labelStr) throws Descriptor.FormException, IOException {
        this(template, nodeDescription, cloud.name, labelStr, (RetentionStrategy)new OnceRetentionStrategy(cloud.getRetentionTimeout()));
    }

    @Deprecated
    public KubernetesSlave(PodTemplate template, String nodeDescription, KubernetesCloud cloud, Label label) throws Descriptor.FormException, IOException {
        this(template, nodeDescription, cloud.name, label.toString(), (RetentionStrategy)new OnceRetentionStrategy(cloud.getRetentionTimeout()));
    }

    @Deprecated
    public KubernetesSlave(PodTemplate template, String nodeDescription, KubernetesCloud cloud, String labelStr, RetentionStrategy rs) throws Descriptor.FormException, IOException {
        this(template, nodeDescription, cloud.name, labelStr, rs);
    }

    @Deprecated
    @DataBoundConstructor
    public KubernetesSlave(PodTemplate template, String nodeDescription, String cloudName, String labelStr, RetentionStrategy rs) throws Descriptor.FormException, IOException {
        this(KubernetesSlave.getSlaveName(template), template, nodeDescription, cloudName, labelStr, (ComputerLauncher)new KubernetesLauncher(), rs);
    }

    protected KubernetesSlave(String name, PodTemplate template, String nodeDescription, String cloudName, String labelStr, ComputerLauncher computerLauncher, RetentionStrategy rs) throws Descriptor.FormException, IOException {
        super(name, nodeDescription, template.getRemoteFs(), 1, template.getNodeUsageMode() != null ? template.getNodeUsageMode() : Node.Mode.NORMAL, labelStr == null ? null : labelStr, computerLauncher, rs, (List)((Object)template.getNodeProperties()));
        this.cloudName = cloudName;
        this.namespace = Util.fixEmpty((String)template.getNamespace());
        this.template = template;
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Deprecated
    public Cloud getCloud() {
        return Jenkins.getInstance().getCloud(this.getCloudName());
    }

    @Nonnull
    public KubernetesCloud getKubernetesCloud() {
        Cloud cloud = Jenkins.getInstance().getCloud(this.getCloudName());
        if (cloud instanceof KubernetesCloud) {
            return (KubernetesCloud)cloud;
        }
        throw new IllegalStateException(((Object)((Object)this)).getClass().getName() + " can be launched only by instances of " + KubernetesCloud.class.getName());
    }

    static String getSlaveName(PodTemplate template) {
        String randString = RandomStringUtils.random((int)5, (String)"bcdfghjklmnpqrstvwxz0123456789");
        String name = template.getName();
        if (StringUtils.isEmpty((String)name)) {
            return String.format("%s-%s", DEFAULT_AGENT_PREFIX, randString);
        }
        name = name.replaceAll("[ _]", "-").toLowerCase();
        name = name.substring(0, Math.min(name.length(), 62 - randString.length()));
        return String.format("%s-%s", name, randString);
    }

    public KubernetesComputer createComputer() {
        return new KubernetesComputer(this);
    }

    protected void _terminate(TaskListener listener) throws IOException, InterruptedException {
        KubernetesClient client;
        KubernetesCloud cloud;
        LOGGER.log(Level.INFO, "Terminating Kubernetes instance for agent {0}", this.name);
        Computer computer = this.toComputer();
        if (computer == null) {
            String msg = String.format("Computer for agent is null: %s", this.name);
            LOGGER.log(Level.SEVERE, msg);
            listener.fatalError(msg);
            return;
        }
        OfflineCause offlineCause = OfflineCause.create((Localizable)new Localizable(HOLDER, "offline", new Object[0]));
        Future disconnected = computer.disconnect(offlineCause);
        try {
            disconnected.get(DISCONNECTION_TIMEOUT.intValue(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            String msg = String.format("Ignoring error waiting for agent disconnection %s: %s", this.name, e.getMessage());
            LOGGER.log(Level.INFO, msg, e);
        }
        if (this.getCloudName() == null) {
            String msg = String.format("Cloud name is not set for agent, can't terminate: %s", this.name);
            LOGGER.log(Level.SEVERE, msg);
            listener.fatalError(msg);
            return;
        }
        try {
            cloud = this.getKubernetesCloud();
        }
        catch (IllegalStateException e) {
            e.printStackTrace(listener.fatalError("Unable to terminate agent. Cloud may have been removed. There may be leftover resources on the Kubernetes cluster."));
            LOGGER.log(Level.SEVERE, String.format("Unable to terminate agent %s. Cloud may have been removed. There may be leftover resources on the Kubernetes cluster.", this.name));
            return;
        }
        try {
            client = cloud.connect();
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateEncodingException e) {
            String msg = String.format("Failed to connect to cloud %s", this.getCloudName());
            e.printStackTrace(listener.fatalError(msg));
            return;
        }
        String actualNamespace = this.getNamespace() == null ? client.getNamespace() : this.getNamespace();
        try {
            Boolean deleted = (Boolean)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(actualNamespace)).withName(this.name)).delete();
            if (!Boolean.TRUE.equals(deleted)) {
                String msg = String.format("Failed to delete pod for agent %s/%s: not found", actualNamespace, this.name);
                LOGGER.log(Level.WARNING, msg);
                listener.error(msg);
                return;
            }
        }
        catch (KubernetesClientException e) {
            String msg = String.format("Failed to delete pod for agent %s/%s: %s", actualNamespace, this.name, e.getMessage());
            LOGGER.log(Level.WARNING, msg, e);
            listener.error(msg);
            return;
        }
        String msg = String.format("Terminated Kubernetes instance for agent %s/%s", actualNamespace, this.name);
        LOGGER.log(Level.INFO, msg);
        listener.getLogger().println(msg);
        LOGGER.log(Level.INFO, "Disconnected computer {0}", this.name);
    }

    public String toString() {
        return String.format("KubernetesSlave name: %s", this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubernetesSlave that = (KubernetesSlave)((Object)o);
        if (this.cloudName != null ? !this.cloudName.equals(that.cloudName) : that.cloudName != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        return this.template != null ? this.template.equals(that.template) : that.template == null;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.cloudName != null ? this.cloudName.hashCode() : 0);
        result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
        result = 31 * result + (this.template != null ? this.template.hashCode() : 0);
        return result;
    }

    public Launcher createLauncher(TaskListener listener) {
        Queue.Executable currentExecutable;
        Executor executor;
        if (this.template != null && (executor = Executor.currentExecutor()) != null && (currentExecutable = executor.getCurrentExecutable()) != null && this.executables.add(currentExecutable)) {
            listener.getLogger().println(Messages.KubernetesSlave_AgentIsProvisionedFromTemplate(ModelHyperlinkNote.encodeTo((String)("/computer/" + this.getNodeName()), (String)this.getNodeName()), this.getTemplate().getDisplayName()));
            listener.getLogger().println(this.getTemplate().getDescriptionForLogging());
        }
        return super.createLauncher(listener);
    }

    protected Object readResolve() {
        this.executables = new HashSet<Queue.Executable>();
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Extension
    public static final class DescriptorImpl
    extends Slave.SlaveDescriptor {
        public String getDisplayName() {
            return "Kubernetes Agent";
        }

        public boolean isInstantiable() {
            return false;
        }
    }

    public static class Builder {
        private String name;
        private String nodeDescription;
        private PodTemplate podTemplate;
        private KubernetesCloud cloud;
        private String label;
        private ComputerLauncher computerLauncher;
        private RetentionStrategy retentionStrategy;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder nodeDescription(String nodeDescription) {
            this.nodeDescription = nodeDescription;
            return this;
        }

        public Builder podTemplate(PodTemplate podTemplate) {
            this.podTemplate = podTemplate;
            return this;
        }

        public Builder cloud(KubernetesCloud cloud) {
            this.cloud = cloud;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder computerLauncher(ComputerLauncher computerLauncher) {
            this.computerLauncher = computerLauncher;
            return this;
        }

        public Builder retentionStrategy(RetentionStrategy retentionStrategy) {
            this.retentionStrategy = retentionStrategy;
            return this;
        }

        private RetentionStrategy determineRetentionStrategy() {
            if (this.podTemplate.getIdleMinutes() == 0) {
                return new OnceRetentionStrategy(this.cloud.getRetentionTimeout());
            }
            return new CloudRetentionStrategy(this.podTemplate.getIdleMinutes());
        }

        public KubernetesSlave build() throws IOException, Descriptor.FormException {
            Validate.notNull((Object)this.podTemplate);
            Validate.notNull((Object)((Object)this.cloud));
            return new KubernetesSlave(this.name == null ? KubernetesSlave.getSlaveName(this.podTemplate) : this.name, this.podTemplate, this.nodeDescription == null ? this.podTemplate.getName() : this.nodeDescription, this.cloud.name, this.label == null ? this.podTemplate.getLabel() : this.label, (ComputerLauncher)(this.computerLauncher == null ? new KubernetesLauncher() : this.computerLauncher), this.retentionStrategy == null ? this.determineRetentionStrategy() : this.retentionStrategy);
        }
    }
}

