/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import hudson.model.TaskListener;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.SlaveComputer;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.PrettyLoggable;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesComputer;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.kohsuke.stapler.DataBoundConstructor;

public class KubernetesLauncher
extends JNLPLauncher {
    private static final Logger LOGGER = Logger.getLogger(KubernetesLauncher.class.getName());
    private boolean launched;

    @DataBoundConstructor
    public KubernetesLauncher(String tunnel, String vmargs) {
        super(tunnel, vmargs);
    }

    public KubernetesLauncher() {
    }

    public boolean isLaunchSupported() {
        return !this.launched;
    }

    public void launch(SlaveComputer computer, TaskListener listener) {
        PrintStream logger = listener.getLogger();
        if (!(computer instanceof KubernetesComputer)) {
            throw new IllegalArgumentException("This Launcher can be used only with KubernetesComputer");
        }
        KubernetesComputer kubernetesComputer = (KubernetesComputer)computer;
        computer.setAcceptingTasks(false);
        KubernetesSlave slave = (KubernetesSlave)kubernetesComputer.getNode();
        if (slave == null) {
            throw new IllegalStateException("Node has been removed, cannot launch " + computer.getName());
        }
        if (this.launched) {
            LOGGER.log(Level.INFO, "Agent has already been launched, activating: {}", slave.getNodeName());
            computer.setAcceptingTasks(true);
            return;
        }
        KubernetesCloud cloud = slave.getKubernetesCloud();
        PodTemplate unwrappedTemplate = slave.getTemplate();
        try {
            String status;
            int i;
            KubernetesClient client = cloud.connect();
            Pod pod = this.getPodTemplate(client, slave, unwrappedTemplate);
            String podId = pod.getMetadata().getName();
            String namespace = StringUtils.defaultIfBlank((String)slave.getNamespace(), (String)client.getNamespace());
            LOGGER.log(Level.FINE, "Creating Pod: {0} in namespace {1}", new Object[]{podId, namespace});
            pod = (Pod)((NonNamespaceOperation)client.pods().inNamespace(namespace)).create((Object[])new Pod[]{pod});
            LOGGER.log(Level.INFO, "Created Pod: {0} in namespace {1}", new Object[]{podId, namespace});
            logger.printf("Created Pod: %s in namespace %s%n", podId, namespace);
            ImmutableList validStates = ImmutableList.of((Object)"Running");
            int j = 100;
            List containerStatuses = null;
            for (i = 0; i < j; ++i) {
                LOGGER.log(Level.INFO, "Waiting for Pod to be scheduled ({1}/{2}): {0}", new Object[]{podId, i, j});
                logger.printf("Waiting for Pod to be scheduled (%2$s/%3$s): %1$s%n", podId, i, j);
                Thread.sleep(6000L);
                pod = (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(podId)).get();
                if (pod == null) {
                    throw new IllegalStateException("Pod no longer exists: " + podId);
                }
                containerStatuses = pod.getStatus().getContainerStatuses();
                ArrayList<ContainerStatus> terminatedContainers = new ArrayList<ContainerStatus>();
                Boolean allContainersAreReady = true;
                for (ContainerStatus info2 : containerStatuses) {
                    if (info2 == null) continue;
                    if (info2.getState().getWaiting() != null) {
                        LOGGER.log(Level.INFO, "Container is waiting {0} [{2}]: {1}", new Object[]{podId, info2.getState().getWaiting(), info2.getName()});
                        logger.printf("Container is waiting %1$s [%3$s]: %2$s%n", podId, info2.getState().getWaiting(), info2.getName());
                    }
                    if (info2.getState().getTerminated() != null) {
                        terminatedContainers.add(info2);
                        continue;
                    }
                    if (info2.getReady().booleanValue()) continue;
                    allContainersAreReady = false;
                }
                if (!terminatedContainers.isEmpty()) {
                    Map<String, Integer> errors = terminatedContainers.stream().collect(Collectors.toMap(ContainerStatus::getName, info -> info.getState().getTerminated().getExitCode()));
                    this.logLastLines(terminatedContainers, podId, namespace, slave, errors, client);
                    throw new IllegalStateException("Containers are terminated with exit codes: " + errors);
                }
                if (allContainersAreReady.booleanValue() && validStates.contains(pod.getStatus().getPhase())) break;
            }
            if (!validStates.contains(status = pod.getStatus().getPhase())) {
                throw new IllegalStateException("Container is not running after " + j + " attempts, status: " + status);
            }
            j = unwrappedTemplate.getSlaveConnectTimeout();
            while (i < j) {
                if (slave.getComputer() == null) {
                    throw new IllegalStateException("Node was deleted, computer is null");
                }
                if (slave.getComputer().isOnline()) break;
                LOGGER.log(Level.INFO, "Waiting for agent to connect ({1}/{2}): {0}", new Object[]{podId, i, j});
                logger.printf("Waiting for agent to connect (%2$s/%3$s): %1$s%n", podId, i, j);
                Thread.sleep(1000L);
                ++i;
            }
            if (!slave.getComputer().isOnline()) {
                if (containerStatuses != null) {
                    this.logLastLines(containerStatuses, podId, namespace, slave, null, client);
                }
                throw new IllegalStateException("Agent is not connected after " + j + " attempts, status: " + status);
            }
            computer.setAcceptingTasks(true);
        }
        catch (Throwable ex) {
            LOGGER.log(Level.WARNING, String.format("Error in provisioning; agent=%s, template=%s", new Object[]{slave, unwrappedTemplate}), ex);
            LOGGER.log(Level.FINER, "Removing Jenkins node: {0}", slave.getNodeName());
            try {
                slave.terminate();
            }
            catch (IOException | InterruptedException e) {
                LOGGER.log(Level.WARNING, "Unable to remove Jenkins node", e);
            }
            throw Throwables.propagate((Throwable)ex);
        }
        this.launched = true;
        try {
            slave.save();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not save() agent: " + e.getMessage(), e);
        }
    }

    private Pod getPodTemplate(KubernetesClient client, KubernetesSlave slave, PodTemplate template) {
        return template == null ? null : template.build(client, slave);
    }

    private void logLastLines(List<ContainerStatus> containers, String podId, String namespace, KubernetesSlave slave, Map<String, Integer> errors, KubernetesClient client) {
        for (ContainerStatus containerStatus : containers) {
            String containerName = containerStatus.getName();
            PrettyLoggable tailingLines = (PrettyLoggable)((ContainerResource)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(podId)).inContainer((Object)containerStatus.getName())).tailingLines(30);
            String log = (String)tailingLines.getLog();
            if (StringUtils.isBlank((String)log)) continue;
            String msg = errors != null ? String.format(" exited with error %s", errors.get(containerName)) : "";
            LOGGER.log(Level.SEVERE, "Error in provisioning; agent={0}, template={1}. Container {2}{3}. Logs: {4}", new Object[]{slave, slave.getTemplate(), containerName, msg, tailingLines.getLog()});
        }
    }
}

