/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.google.common.base.Preconditions;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.csanchez.jenkins.plugins.kubernetes.ContainerLivenessProbe;
import org.csanchez.jenkins.plugins.kubernetes.Messages;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateUtils;
import org.csanchez.jenkins.plugins.kubernetes.PortMapping;
import org.csanchez.jenkins.plugins.kubernetes.model.TemplateEnvVar;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ContainerTemplate
extends AbstractDescribableImpl<ContainerTemplate>
implements Serializable {
    private static final long serialVersionUID = 4212681620316294146L;
    public static final String DEFAULT_WORKING_DIR = "/home/jenkins";
    private String name;
    private String image;
    private boolean privileged;
    private boolean alwaysPullImage;
    private String workingDir = "/home/jenkins";
    private String command;
    private String args;
    private boolean ttyEnabled;
    private String resourceRequestCpu;
    private String resourceRequestMemory;
    private String resourceLimitCpu;
    private String resourceLimitMemory;
    private String shell;
    private final List<TemplateEnvVar> envVars = new ArrayList<TemplateEnvVar>();
    private List<PortMapping> ports = new ArrayList<PortMapping>();
    private ContainerLivenessProbe livenessProbe;

    @Deprecated
    public ContainerTemplate(String image) {
        this(null, image);
    }

    @DataBoundConstructor
    public ContainerTemplate(String name, String image) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)image) ? 1 : 0) != 0);
        this.name = name;
        this.image = image;
    }

    public ContainerTemplate(String name, String image, String command, String args) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)image) ? 1 : 0) != 0);
        this.name = name;
        this.image = image;
        this.command = command;
        this.args = args;
    }

    public ContainerTemplate(ContainerTemplate from) {
        this.setName(from.getName());
        this.setImage(from.getImage());
        this.setPrivileged(from.isPrivileged());
        this.setAlwaysPullImage(from.isAlwaysPullImage());
        this.setWorkingDir(from.getWorkingDir());
        this.setCommand(from.getCommand());
        this.setArgs(from.getArgs());
        this.setTtyEnabled(from.isTtyEnabled());
        this.setResourceRequestCpu(from.getResourceRequestCpu());
        this.setResourceRequestMemory(from.getResourceRequestMemory());
        this.setResourceLimitCpu(from.getResourceLimitCpu());
        this.setResourceLimitMemory(from.getResourceLimitMemory());
        this.setShell(from.getShell());
        this.setEnvVars(from.getEnvVars());
        this.setPorts(from.getPorts());
        this.setLivenessProbe(from.getLivenessProbe());
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @DataBoundSetter
    public void setImage(String image) {
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    @DataBoundSetter
    public void setCommand(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    @DataBoundSetter
    public void setArgs(String args) {
        this.args = args;
    }

    public String getArgs() {
        return this.args;
    }

    @DataBoundSetter
    public void setTtyEnabled(boolean ttyEnabled) {
        this.ttyEnabled = ttyEnabled;
    }

    public boolean isTtyEnabled() {
        return this.ttyEnabled;
    }

    public String getDisplayName() {
        return "Container Pod Template";
    }

    @DataBoundSetter
    public void setWorkingDir(String workingDir) {
        this.workingDir = Util.fixEmpty((String)workingDir);
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    @DataBoundSetter
    public void setPrivileged(boolean privileged) {
        this.privileged = privileged;
    }

    public boolean isPrivileged() {
        return this.privileged;
    }

    @DataBoundSetter
    public void setAlwaysPullImage(boolean alwaysPullImage) {
        this.alwaysPullImage = alwaysPullImage;
    }

    public boolean isAlwaysPullImage() {
        return this.alwaysPullImage;
    }

    public List<TemplateEnvVar> getEnvVars() {
        return this.envVars != null ? this.envVars : Collections.emptyList();
    }

    @DataBoundSetter
    public void setEnvVars(List<TemplateEnvVar> envVars) {
        this.envVars.addAll(envVars);
    }

    public ContainerLivenessProbe getLivenessProbe() {
        return this.livenessProbe;
    }

    @DataBoundSetter
    public void setLivenessProbe(ContainerLivenessProbe livenessProbe) {
        this.livenessProbe = livenessProbe;
    }

    public List<PortMapping> getPorts() {
        return this.ports != null ? this.ports : Collections.emptyList();
    }

    @DataBoundSetter
    public void setPorts(List<PortMapping> ports) {
        this.ports = ports;
    }

    public String getResourceRequestMemory() {
        return this.resourceRequestMemory;
    }

    @DataBoundSetter
    public void setResourceRequestMemory(String resourceRequestMemory) {
        this.resourceRequestMemory = resourceRequestMemory;
    }

    public String getResourceLimitCpu() {
        return this.resourceLimitCpu;
    }

    @DataBoundSetter
    public void setResourceLimitCpu(String resourceLimitCpu) {
        this.resourceLimitCpu = resourceLimitCpu;
    }

    public String getResourceLimitMemory() {
        return this.resourceLimitMemory;
    }

    @DataBoundSetter
    public void setResourceLimitMemory(String resourceLimitMemory) {
        this.resourceLimitMemory = resourceLimitMemory;
    }

    public String getResourceRequestCpu() {
        return this.resourceRequestCpu;
    }

    @DataBoundSetter
    public void setResourceRequestCpu(String resourceRequestCpu) {
        this.resourceRequestCpu = resourceRequestCpu;
    }

    public String getShell() {
        return this.shell;
    }

    @DataBoundSetter
    public void setShell(String shell) {
        this.shell = shell;
    }

    public Map<String, Object> getAsArgs() {
        TreeMap<String, Object> argMap = new TreeMap<String, Object>();
        argMap.put("name", this.name);
        if (!StringUtils.isEmpty((String)this.shell)) {
            argMap.put("shell", this.shell);
        }
        return argMap;
    }

    public String toString() {
        return "ContainerTemplate{" + (this.name == null ? "" : "name='" + this.name + '\'') + (this.image == null ? "" : ", image='" + this.image + '\'') + (!this.privileged ? "" : ", privileged=" + this.privileged) + (!this.alwaysPullImage ? "" : ", alwaysPullImage=" + this.alwaysPullImage) + (this.workingDir == null ? "" : ", workingDir='" + this.workingDir + '\'') + (this.command == null ? "" : ", command='" + this.command + '\'') + (this.args == null ? "" : ", args='" + this.args + '\'') + (!this.ttyEnabled ? "" : ", ttyEnabled=" + this.ttyEnabled) + (this.resourceRequestCpu == null ? "" : ", resourceRequestCpu='" + this.resourceRequestCpu + '\'') + (this.resourceRequestMemory == null ? "" : ", resourceRequestMemory='" + this.resourceRequestMemory + '\'') + (this.resourceLimitCpu == null ? "" : ", resourceLimitCpu='" + this.resourceLimitCpu + '\'') + (this.resourceLimitMemory == null ? "" : ", resourceLimitMemory='" + this.resourceLimitMemory + '\'') + (this.envVars == null || this.envVars.isEmpty() ? "" : ", envVars=" + this.envVars) + (this.ports == null || this.ports.isEmpty() ? "" : ", ports=" + this.ports) + (this.livenessProbe == null ? "" : ", livenessProbe=" + this.livenessProbe) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerTemplate that = (ContainerTemplate)o;
        if (this.privileged != that.privileged) {
            return false;
        }
        if (this.alwaysPullImage != that.alwaysPullImage) {
            return false;
        }
        if (this.ttyEnabled != that.ttyEnabled) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.workingDir != null ? !this.workingDir.equals(that.workingDir) : that.workingDir != null) {
            return false;
        }
        if (this.command != null ? !this.command.equals(that.command) : that.command != null) {
            return false;
        }
        if (this.args != null ? !this.args.equals(that.args) : that.args != null) {
            return false;
        }
        if (this.resourceRequestCpu != null ? !this.resourceRequestCpu.equals(that.resourceRequestCpu) : that.resourceRequestCpu != null) {
            return false;
        }
        if (this.resourceRequestMemory != null ? !this.resourceRequestMemory.equals(that.resourceRequestMemory) : that.resourceRequestMemory != null) {
            return false;
        }
        if (this.resourceLimitCpu != null ? !this.resourceLimitCpu.equals(that.resourceLimitCpu) : that.resourceLimitCpu != null) {
            return false;
        }
        if (this.resourceLimitMemory != null ? !this.resourceLimitMemory.equals(that.resourceLimitMemory) : that.resourceLimitMemory != null) {
            return false;
        }
        if (this.shell != null ? !this.shell.equals(that.shell) : that.shell != null) {
            return false;
        }
        if (this.envVars != null ? !this.envVars.equals(that.envVars) : that.envVars != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        return this.livenessProbe != null ? this.livenessProbe.equals(that.livenessProbe) : that.livenessProbe == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.image != null ? this.image.hashCode() : 0);
        result = 31 * result + (this.privileged ? 1 : 0);
        result = 31 * result + (this.alwaysPullImage ? 1 : 0);
        result = 31 * result + (this.workingDir != null ? this.workingDir.hashCode() : 0);
        result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
        result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
        result = 31 * result + (this.ttyEnabled ? 1 : 0);
        result = 31 * result + (this.resourceRequestCpu != null ? this.resourceRequestCpu.hashCode() : 0);
        result = 31 * result + (this.resourceRequestMemory != null ? this.resourceRequestMemory.hashCode() : 0);
        result = 31 * result + (this.resourceLimitCpu != null ? this.resourceLimitCpu.hashCode() : 0);
        result = 31 * result + (this.resourceLimitMemory != null ? this.resourceLimitMemory.hashCode() : 0);
        result = 31 * result + (this.shell != null ? this.shell.hashCode() : 0);
        result = 31 * result + (this.envVars != null ? this.envVars.hashCode() : 0);
        result = 31 * result + (this.ports != null ? this.ports.hashCode() : 0);
        result = 31 * result + (this.livenessProbe != null ? this.livenessProbe.hashCode() : 0);
        return result;
    }

    private Object readResolve() {
        this.workingDir = Util.fixEmpty((String)this.workingDir);
        return this;
    }

    @Extension
    @Symbol(value={"containerTemplate"})
    public static class DescriptorImpl
    extends Descriptor<ContainerTemplate> {
        public String getDisplayName() {
            return "Container Template";
        }

        @Restricted(value={DoNotUse.class})
        public List<? extends Descriptor> getEnvVarsDescriptors() {
            return DescriptorVisibilityFilter.apply(null, (Iterable)Jenkins.getInstance().getDescriptorList(TemplateEnvVar.class));
        }

        public FormValidation doCheckName(@QueryParameter String value) {
            if (!PodTemplateUtils.validateContainerName(value)) {
                return FormValidation.error((String)Messages.RFC1123_error(value));
            }
            return FormValidation.ok();
        }
    }
}

