/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.volumes;

import hudson.Extension;
import hudson.model.Descriptor;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import org.csanchez.jenkins.plugins.kubernetes.volumes.PodVolume;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class SecretVolume
extends PodVolume {
    private String mountPath;
    private String secretName;

    @DataBoundConstructor
    public SecretVolume(String mountPath, String secretName) {
        this.mountPath = mountPath;
        this.secretName = secretName;
    }

    @Override
    public Volume buildVolume(String volumeName) {
        return ((VolumeBuilder)((VolumeFluent.SecretNested)((VolumeBuilder)new VolumeBuilder().withName(volumeName)).withNewSecret().withSecretName(this.getSecretName())).endSecret()).build();
    }

    public String getSecretName() {
        return this.secretName;
    }

    @Override
    public String getMountPath() {
        return this.mountPath;
    }

    @Extension
    @Symbol(value={"secretVolume"})
    public static class DescriptorImpl
    extends Descriptor<PodVolume> {
        public String getDisplayName() {
            return "Secret Volume";
        }
    }
}

