/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import com.google.common.base.Strings;
import hudson.AbortException;
import hudson.model.Run;
import hudson.slaves.Cloud;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.RandomStringUtils;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.NamespaceAction;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.PodTemplateAction;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.PodTemplateStep;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class PodTemplateStepExecution
extends AbstractStepExecutionImpl {
    private static final Logger LOGGER = Logger.getLogger(PodTemplateStepExecution.class.getName());
    private static final long serialVersionUID = -6139090518333729333L;
    private static final transient String NAME_FORMAT = "%s-%s";
    private final PodTemplateStep step;

    PodTemplateStepExecution(PodTemplateStep step, StepContext context) {
        super(context);
        this.step = step;
    }

    public boolean start() throws Exception {
        Cloud cloud = Jenkins.getInstance().getCloud(this.step.getCloud());
        if (cloud == null) {
            throw new AbortException(String.format("Cloud does not exist: %s", this.step.getCloud()));
        }
        if (!(cloud instanceof KubernetesCloud)) {
            throw new AbortException(String.format("Cloud is not a Kubernetes cloud: %s (%s)", this.step.getCloud(), cloud.getClass().getName()));
        }
        KubernetesCloud kubernetesCloud = (KubernetesCloud)cloud;
        PodTemplateAction podTemplateAction = new PodTemplateAction((Run)this.getContext().get(Run.class));
        NamespaceAction namespaceAction = new NamespaceAction((Run)this.getContext().get(Run.class));
        String randString = RandomStringUtils.random((int)5, (String)"bcdfghjklmnpqrstvwxz0123456789");
        String name = String.format(NAME_FORMAT, this.step.getName(), randString);
        String namespace = this.checkNamespace(kubernetesCloud, namespaceAction);
        PodTemplate newTemplate = new PodTemplate();
        newTemplate.setName(name);
        newTemplate.setNamespace(namespace);
        newTemplate.setInheritFrom(!Strings.isNullOrEmpty((String)podTemplateAction.getParentTemplates()) ? podTemplateAction.getParentTemplates() : this.step.getInheritFrom());
        newTemplate.setInstanceCap(this.step.getInstanceCap());
        newTemplate.setIdleMinutes(this.step.getIdleMinutes());
        newTemplate.setLabel(this.step.getLabel());
        newTemplate.setVolumes(this.step.getVolumes());
        newTemplate.setCustomWorkspaceVolumeEnabled(this.step.getWorkspaceVolume() != null);
        newTemplate.setWorkspaceVolume(this.step.getWorkspaceVolume());
        newTemplate.setContainers(this.step.getContainers());
        newTemplate.setNodeSelector(this.step.getNodeSelector());
        newTemplate.setNodeUsageMode(this.step.getNodeUsageMode());
        newTemplate.setServiceAccount(this.step.getServiceAccount());
        newTemplate.setAnnotations(this.step.getAnnotations());
        kubernetesCloud.addTemplate(newTemplate);
        this.getContext().newBodyInvoker().withContext((Object)this.step).withCallback((BodyExecutionCallback)new PodTemplateCallback(newTemplate)).start();
        podTemplateAction.push(name);
        namespaceAction.push(namespace);
        return false;
    }

    public void stop(Throwable cause) throws Exception {
        new PodTemplateAction((Run)this.getContext().get(Run.class)).pop();
    }

    private String checkNamespace(KubernetesCloud kubernetesCloud, NamespaceAction namespaceAction) {
        String namespace = null;
        if (!Strings.isNullOrEmpty((String)this.step.getNamespace())) {
            namespace = this.step.getNamespace();
        } else if (!Strings.isNullOrEmpty((String)namespaceAction.getNamespace())) {
            namespace = namespaceAction.getNamespace();
        } else if (!Strings.isNullOrEmpty((String)kubernetesCloud.getNamespace())) {
            namespace = kubernetesCloud.getNamespace();
        } else {
            try {
                namespace = kubernetesCloud.connect().getNamespace();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (Strings.isNullOrEmpty((String)namespace)) {
            throw new IllegalStateException("No target namespace has been found.");
        }
        return namespace;
    }

    private class PodTemplateCallback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = 6043919968776851324L;
        private final PodTemplate podTemplate;

        private PodTemplateCallback(PodTemplate podTemplate) {
            this.podTemplate = podTemplate;
        }

        protected void finished(StepContext context) throws Exception {
            Cloud cloud = Jenkins.getInstance().getCloud(PodTemplateStepExecution.this.step.getCloud());
            if (cloud == null) {
                LOGGER.log(Level.FINE, "Cloud {0} no longer exists, cannot delete pod template {1}", new Object[]{PodTemplateStepExecution.this.step.getCloud(), this.podTemplate.getName()});
                return;
            }
            if (cloud instanceof KubernetesCloud) {
                KubernetesCloud kubernetesCloud = (KubernetesCloud)cloud;
                kubernetesCloud.removeTemplate(this.podTemplate);
                ((PodResource)kubernetesCloud.connect().pods().withName(this.podTemplate.getName())).delete();
            }
        }
    }
}

