/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import hudson.BulkChange;
import hudson.model.Action;
import hudson.model.InvisibleAction;
import hudson.model.Run;
import hudson.model.Saveable;
import java.io.IOException;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.logging.Logger;

public class NamespaceAction
extends InvisibleAction {
    private static final Logger LOGGER = Logger.getLogger(NamespaceAction.class.getName());
    private final Stack<String> namespaces = new Stack();
    private final Run run;

    public NamespaceAction(Run run) {
        this.run = run;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(String namespace) throws IOException {
        if (this.run == null) {
            LOGGER.warning("run is null, cannot push");
            return;
        }
        Run run = this.run;
        synchronized (run) {
            BulkChange bc = new BulkChange((Saveable)this.run);
            try {
                NamespaceAction action = (NamespaceAction)this.run.getAction(NamespaceAction.class);
                if (action == null) {
                    action = new NamespaceAction(this.run);
                    this.run.addAction((Action)action);
                }
                action.namespaces.push(namespace);
                bc.commit();
            }
            finally {
                bc.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pop() throws IOException {
        if (this.run == null) {
            LOGGER.warning("run is null, cannot pop");
            return null;
        }
        Run run = this.run;
        synchronized (run) {
            BulkChange bc = new BulkChange((Saveable)this.run);
            try {
                NamespaceAction action = (NamespaceAction)this.run.getAction(NamespaceAction.class);
                if (action == null) {
                    action = new NamespaceAction(this.run);
                    this.run.addAction((Action)action);
                }
                String namespace = action.namespaces.pop();
                bc.commit();
                String string = namespace;
                return string;
            }
            finally {
                bc.abort();
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNamespace() {
        Run run = this.run;
        synchronized (run) {
            NamespaceAction action = (NamespaceAction)this.run.getAction(NamespaceAction.class);
            if (action == null) {
                action = new NamespaceAction(this.run);
                this.run.addAction((Action)action);
            }
            try {
                return action.namespaces.peek();
            }
            catch (EmptyStackException e) {
                return null;
            }
        }
    }
}

