/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import hudson.Extension;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.modeldefinition.agent.DeclarativeAgent;
import org.jenkinsci.plugins.pipeline.modeldefinition.agent.DeclarativeAgentDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class KubernetesDeclarativeAgent
extends DeclarativeAgent<KubernetesDeclarativeAgent> {
    private final String label;
    private String cloud;
    private String inheritFrom;
    private int instanceCap;
    private String serviceAccount;
    private String nodeSelector;
    private String workingDir;
    private ContainerTemplate containerTemplate;

    @DataBoundConstructor
    public KubernetesDeclarativeAgent(String label, ContainerTemplate containerTemplate) {
        this.label = label;
        this.containerTemplate = containerTemplate;
    }

    public String getLabel() {
        return this.label;
    }

    public String getCloud() {
        return this.cloud;
    }

    @DataBoundSetter
    public void setCloud(String cloud) {
        this.cloud = cloud;
    }

    public String getInheritFrom() {
        return this.inheritFrom;
    }

    @DataBoundSetter
    public void setInheritFrom(String inheritFrom) {
        this.inheritFrom = inheritFrom;
    }

    public int getInstanceCap() {
        return this.instanceCap;
    }

    @DataBoundSetter
    public void setInstanceCap(int instanceCap) {
        this.instanceCap = instanceCap;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    @DataBoundSetter
    public void setServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    public String getNodeSelector() {
        return this.nodeSelector;
    }

    @DataBoundSetter
    public void setNodeSelector(String nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    @DataBoundSetter
    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public ContainerTemplate getContainerTemplate() {
        return this.containerTemplate;
    }

    public Map<String, Object> getAsArgs() {
        TreeMap<String, Object> argMap = new TreeMap<String, Object>();
        argMap.put("label", this.label);
        argMap.put("name", this.label);
        argMap.put("containers", Collections.singletonList(this.containerTemplate));
        if (!StringUtils.isEmpty((String)this.cloud)) {
            argMap.put("cloud", this.cloud);
        }
        if (!StringUtils.isEmpty((String)this.inheritFrom)) {
            argMap.put("inheritFrom", this.inheritFrom);
        }
        if (!StringUtils.isEmpty((String)this.serviceAccount)) {
            argMap.put("serviceAccount", this.serviceAccount);
        }
        if (!StringUtils.isEmpty((String)this.nodeSelector)) {
            argMap.put("nodeSelector", this.nodeSelector);
        }
        if (!StringUtils.isEmpty((String)this.workingDir)) {
            argMap.put("workingDir", this.workingDir);
        }
        if (this.instanceCap > 0) {
            argMap.put("instanceCap", this.instanceCap);
        }
        return argMap;
    }

    @Extension
    @Symbol(value={"kubernetes"})
    public static class DescriptorImpl
    extends DeclarativeAgentDescriptor<KubernetesDeclarativeAgent> {
    }
}

