/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import com.google.common.io.NullOutputStream;
import hudson.Launcher;
import hudson.LauncherDecorator;
import hudson.Proc;
import hudson.model.Node;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.ExecListenable;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.Execable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import io.fabric8.kubernetes.client.dsl.TtyExecOutputErrorable;
import io.fabric8.kubernetes.client.dsl.TtyExecable;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Response;
import org.apache.commons.io.output.TeeOutputStream;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.ContainerExecProc;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.EvictingQueue;

public class ContainerExecDecorator
extends LauncherDecorator
implements Serializable,
Closeable {
    private static final long serialVersionUID = 4419929753433397655L;
    private static final long DEFAULT_CONTAINER_READY_TIMEOUT = 5L;
    private static final String CONTAINER_READY_TIMEOUT_SYSTEM_PROPERTY = ContainerExecDecorator.class.getName() + ".containerReadyTimeout";
    private static final long CONTAINER_READY_TIMEOUT = ContainerExecDecorator.containerReadyTimeout();
    private static final String COOKIE_VAR = "JENKINS_SERVER_COOKIE";
    private static final Logger LOGGER = Logger.getLogger(ContainerExecDecorator.class.getName());
    private final transient KubernetesClient client;
    private final String podName;
    private final String namespace;
    private final String containerName;
    private transient ExecWatch watch;
    private transient ContainerExecProc proc;

    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, String namespace) {
        this.client = client;
        this.podName = podName;
        this.namespace = namespace;
        this.containerName = containerName;
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, AtomicBoolean alive, CountDownLatch started, CountDownLatch finished, String namespace) {
        this(client, podName, containerName, namespace);
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, AtomicBoolean alive, CountDownLatch started, CountDownLatch finished) {
        this(client, podName, containerName, null);
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, String path, AtomicBoolean alive, CountDownLatch started, CountDownLatch finished) {
        this(client, podName, containerName, null);
    }

    public Launcher decorate(final Launcher launcher, Node node) {
        return new Launcher.DecoratedLauncher(launcher){

            public Proc launch(Launcher.ProcStarter starter) throws IOException {
                PrintStream printStream;
                if (!this.waitUntilContainerIsReady()) {
                    throw new IOException("Failed to execute shell script inside container [" + ContainerExecDecorator.this.containerName + "] of pod [" + ContainerExecDecorator.this.podName + "]. Timed out waiting for container to become ready!");
                }
                final CountDownLatch started = new CountDownLatch(1);
                final CountDownLatch finished = new CountDownLatch(1);
                final AtomicBoolean alive = new AtomicBoolean(false);
                PrintStream stream = printStream = launcher.getListener().getLogger();
                if (starter.quiet()) {
                    stream = new NullOutputStream();
                    printStream = new PrintStream((OutputStream)stream, false, StandardCharsets.UTF_8.toString());
                }
                final ExitCodeOutputStream exitCodeOutputStream = new ExitCodeOutputStream();
                stream = new TeeOutputStream((OutputStream)exitCodeOutputStream, (OutputStream)stream);
                String msg = "Executing shell script inside container [" + ContainerExecDecorator.this.containerName + "] of pod [" + ContainerExecDecorator.this.podName + "]";
                LOGGER.log(Level.FINEST, msg);
                printStream.println(msg);
                ContainerExecDecorator.this.watch = (ExecWatch)((Execable)((ExecListenable)((TtyExecable)((TtyExecErrorable)((TtyExecOutputErrorable)((ContainerResource)((PodResource)((NonNamespaceOperation)ContainerExecDecorator.this.client.pods().inNamespace(ContainerExecDecorator.this.namespace)).withName(ContainerExecDecorator.this.podName)).inContainer((Object)ContainerExecDecorator.this.containerName)).redirectingInput()).writingOutput((Object)stream)).writingError((Object)stream)).withTTY()).usingListener((Object)new ExecListener(){

                    public void onOpen(Response response) {
                        alive.set(true);
                        started.countDown();
                    }

                    public void onFailure(Throwable t, Response response) {
                        alive.set(false);
                        t.printStackTrace(launcher.getListener().getLogger());
                        started.countDown();
                        LOGGER.log(Level.FINEST, "onFailure : {0}", finished);
                        if (finished.getCount() == 0L) {
                            LOGGER.log(Level.WARNING, "onFailure called but latch already finished. This may be a bug in the kubernetes-plugin");
                        }
                        finished.countDown();
                    }

                    public void onClose(int i, String s) {
                        alive.set(false);
                        started.countDown();
                        LOGGER.log(Level.FINEST, "onClose : {0}", finished);
                        if (finished.getCount() == 0L) {
                            LOGGER.log(Level.SEVERE, "onClose called but latch already finished. This indicates a bug in the kubernetes-plugin");
                        }
                        finished.countDown();
                    }
                })).exec((Object[])new String[0]);
                ContainerExecDecorator.waitQuietly(started);
                if (starter.pwd() != null) {
                    ContainerExecDecorator.this.watch.getInput().write(String.format("cd \"%s\"%s", starter.pwd(), "\n").getBytes(StandardCharsets.UTF_8));
                }
                ContainerExecDecorator.doExec(ContainerExecDecorator.this.watch, printStream, ContainerExecDecorator.getCommands(starter));
                ContainerExecDecorator.this.proc = new ContainerExecProc(ContainerExecDecorator.this.watch, alive, finished, new Callable<Integer>(){

                    @Override
                    public Integer call() {
                        return exitCodeOutputStream.getExitCode();
                    }
                });
                return ContainerExecDecorator.this.proc;
            }

            public void kill(Map<String, String> modelEnvVars) throws IOException, InterruptedException {
                this.getListener().getLogger().println("Killing process.");
                ContainerExecDecorator.this.close();
            }

            private boolean isContainerReady(Pod pod, String container) {
                if (pod == null || pod.getStatus() == null || pod.getStatus().getContainerStatuses() == null) {
                    return false;
                }
                for (ContainerStatus info : pod.getStatus().getContainerStatuses()) {
                    if (!info.getName().equals(container) || !info.getReady().booleanValue()) continue;
                    return true;
                }
                return false;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private boolean waitUntilContainerIsReady() {
                int j = 10;
                Pod pod = (Pod)((PodResource)((NonNamespaceOperation)ContainerExecDecorator.this.client.pods().inNamespace(ContainerExecDecorator.this.namespace)).withName(ContainerExecDecorator.this.podName)).get();
                if (pod == null) {
                    launcher.getListener().getLogger().println("Waiting for pod [" + ContainerExecDecorator.this.podName + "] to exist.");
                    for (int i = 0; i < j; ++i) {
                        LOGGER.log(Level.INFO, "Getting pod ({1}/{2}): {0}", new Object[]{ContainerExecDecorator.this.podName, i, j});
                        pod = (Pod)((PodResource)((NonNamespaceOperation)ContainerExecDecorator.this.client.pods().inNamespace(ContainerExecDecorator.this.namespace)).withName(ContainerExecDecorator.this.podName)).get();
                        if (pod != null) break;
                        LOGGER.log(Level.INFO, "Waiting 6 seconds before checking if pod exists ({1}/{2}): {0}", new Object[]{ContainerExecDecorator.this.podName, i, j});
                        try {
                            Thread.sleep(6000L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            return false;
                        }
                    }
                }
                if (pod == null) {
                    throw new IllegalArgumentException("Container with name:[" + ContainerExecDecorator.this.containerName + "] not found in pod:[" + ContainerExecDecorator.this.podName + "], pod doesn't exist");
                }
                if (this.isContainerReady(pod, ContainerExecDecorator.this.containerName)) {
                    return true;
                }
                launcher.getListener().getLogger().println("Waiting for container container [" + ContainerExecDecorator.this.containerName + "] of pod [" + ContainerExecDecorator.this.podName + "] to become ready.");
                final CountDownLatch latch = new CountDownLatch(1);
                Watcher<Pod> podWatcher = new Watcher<Pod>(){

                    public void eventReceived(Watcher.Action action, Pod resource) {
                        switch (action) {
                            case MODIFIED: {
                                if (!this.isContainerReady(resource, ContainerExecDecorator.this.containerName)) break;
                                latch.countDown();
                                break;
                            }
                        }
                    }

                    public void onClose(KubernetesClientException cause) {
                    }
                };
                try (Watch watch = (Watch)((PodResource)((NonNamespaceOperation)ContainerExecDecorator.this.client.pods().inNamespace(ContainerExecDecorator.this.namespace)).withName(ContainerExecDecorator.this.podName)).watch((Object)podWatcher);){
                    if (!latch.await(CONTAINER_READY_TIMEOUT, TimeUnit.MINUTES)) return false;
                    boolean bl = true;
                    return bl;
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
        };
    }

    @Override
    public void close() throws IOException {
        if (this.watch != null) {
            try {
                this.watch.close();
            }
            catch (IllegalStateException e) {
                LOGGER.log(Level.INFO, "Watch was already closed: {0}", e.getMessage());
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error closing watch", e);
            }
            finally {
                this.watch = null;
            }
        }
        if (this.proc != null) {
            try {
                this.proc.kill();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }
    }

    private static void doExec(ExecWatch watch, PrintStream out, String ... statements) {
        try {
            out.print("Executing command: ");
            StringBuilder sb = new StringBuilder();
            for (String stmt : statements) {
                String s = String.format("\"%s\" ", stmt);
                sb.append(s);
                out.print(s);
                watch.getInput().write(s.getBytes(StandardCharsets.UTF_8));
            }
            sb.append("\n");
            out.println();
            watch.getInput().write("\n".getBytes(StandardCharsets.UTF_8));
            sb.append("printf \"EXITCODE %3d\" $?; exit\n");
            out.print("printf \"EXITCODE %3d\" $?; exit\n");
            LOGGER.log(Level.FINEST, "Executing command: {0}", sb.toString());
            watch.getInput().write("printf \"EXITCODE %3d\" $?; exit\n".getBytes(StandardCharsets.UTF_8));
            out.flush();
            watch.getInput().flush();
        }
        catch (IOException e) {
            e.printStackTrace(out);
            throw new RuntimeException(e);
        }
    }

    static String[] getCommands(Launcher.ProcStarter starter) {
        ArrayList<String> allCommands = new ArrayList<String>();
        for (String cmd : starter.cmds()) {
            allCommands.add(cmd.replaceAll("\\$\\$", "\\\\\\$"));
        }
        return allCommands.toArray(new String[allCommands.size()]);
    }

    private static void waitQuietly(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static Long containerReadyTimeout() {
        String timeout = System.getProperty(CONTAINER_READY_TIMEOUT_SYSTEM_PROPERTY, String.valueOf(5L));
        try {
            return Long.parseLong(timeout);
        }
        catch (NumberFormatException e) {
            return 5L;
        }
    }

    static class ExitCodeOutputStream
    extends OutputStream {
        public static final String EXIT_COMMAND_TXT = "EXITCODE";
        public static final String EXIT_COMMAND = "printf \"EXITCODE %3d\" $?; exit\n";
        private EvictingQueue<Integer> queue = EvictingQueue.create(20);

        @Override
        public void write(int b) throws IOException {
            this.queue.add(b);
            byte[] bb = new byte[]{(byte)b};
            System.out.print(new String(bb, StandardCharsets.UTF_8));
        }

        public int getExitCode() {
            ByteBuffer b = ByteBuffer.allocate(this.queue.size());
            this.queue.stream().filter(Objects::nonNull).forEach(i -> b.put((byte)i.intValue()));
            int i2 = 1;
            String s = new String(b.array(), StandardCharsets.UTF_8);
            if (s.indexOf(EXIT_COMMAND_TXT) < 0) {
                LOGGER.log(Level.WARNING, "Unable to find \"{0}\" in {1}", new Object[]{EXIT_COMMAND_TXT, s});
                return i2;
            }
            int start = s.indexOf(EXIT_COMMAND_TXT) + EXIT_COMMAND_TXT.length();
            s = s.substring(start, start + 4).trim();
            try {
                i2 = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "Unable to parse exit code as integer: \"{0}\" {1} / {2}", new Object[]{s, this.queue.toString(), Arrays.toString(b.array())});
            }
            return i2;
        }
    }
}

