/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.csanchez.jenkins.plugins.kubernetes.TokenProducer;
import org.kohsuke.stapler.DataBoundConstructor;

public class ServiceAccountCredential
extends BaseStandardCredentials
implements TokenProducer {
    private static final String SERVICEACCOUNT_TOKEN_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/token";

    @DataBoundConstructor
    public ServiceAccountCredential(CredentialsScope scope, String id, String description) {
        super(scope, id, description);
    }

    @Override
    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    public String getToken(String serviceAddress, String caCertData, boolean skipTlsVerify) {
        try {
            return FileUtils.readFileToString((File)new File(SERVICEACCOUNT_TOKEN_PATH));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
        public DescriptorImpl() {
            if (!new File(ServiceAccountCredential.SERVICEACCOUNT_TOKEN_PATH).exists()) {
                throw new RuntimeException("Jenkins isn't running inside Kubernetes with Admission Controller.");
            }
        }

        public String getDisplayName() {
            return "Kubernetes Service Account";
        }
    }
}

