/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import hudson.model.Label;
import hudson.model.Node;
import hudson.tools.ToolLocationNodeProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.csanchez.jenkins.plugins.kubernetes.ContainerEnvVar;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodEnvVar;
import org.csanchez.jenkins.plugins.kubernetes.PodImagePullSecret;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.volumes.PodVolume;
import org.csanchez.jenkins.plugins.kubernetes.volumes.workspace.WorkspaceVolume;

public class PodTemplateUtils {
    private static final String PLACEHOLDER_KEY = "key";
    private static final String PLACEHOLDER_FORMAT = "\\$\\{%s\\}";
    private static final String PLACEHOLDER_REGEX = String.format("\\$\\{%s\\}", "(?<key>[a-zA-Z0-9_]+)");
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile(PLACEHOLDER_REGEX);

    public static ContainerTemplate combine(@CheckForNull ContainerTemplate parent, @Nonnull ContainerTemplate template) {
        String args;
        boolean alwaysPullImage;
        boolean privileged;
        String image;
        Preconditions.checkNotNull((Object)template, (Object)"Container template should not be null");
        if (parent == null) {
            return template;
        }
        String name = template.getName();
        String string = image = Strings.isNullOrEmpty((String)template.getImage()) ? parent.getImage() : template.getImage();
        boolean bl = template.isPrivileged() ? template.isPrivileged() : (privileged = parent.isPrivileged() ? parent.isPrivileged() : false);
        boolean bl2 = template.isAlwaysPullImage() ? template.isAlwaysPullImage() : (alwaysPullImage = parent.isAlwaysPullImage() ? parent.isAlwaysPullImage() : false);
        String workingDir = Strings.isNullOrEmpty((String)template.getWorkingDir()) ? (Strings.isNullOrEmpty((String)parent.getWorkingDir()) ? "/home/jenkins" : parent.getWorkingDir()) : template.getWorkingDir();
        String command = Strings.isNullOrEmpty((String)template.getCommand()) ? parent.getCommand() : template.getCommand();
        String string2 = args = Strings.isNullOrEmpty((String)template.getArgs()) ? parent.getArgs() : template.getArgs();
        boolean ttyEnabled = template.isTtyEnabled() ? template.isTtyEnabled() : (parent.isTtyEnabled() ? parent.isTtyEnabled() : false);
        String resourceRequestCpu = Strings.isNullOrEmpty((String)template.getResourceRequestCpu()) ? parent.getResourceRequestCpu() : template.getResourceRequestCpu();
        String resourceRequestMemory = Strings.isNullOrEmpty((String)template.getResourceRequestMemory()) ? parent.getResourceRequestMemory() : template.getResourceRequestMemory();
        String resourceLimitCpu = Strings.isNullOrEmpty((String)template.getResourceLimitCpu()) ? parent.getResourceLimitCpu() : template.getResourceLimitCpu();
        String resourceLimitMemory = Strings.isNullOrEmpty((String)template.getResourceLimitMemory()) ? parent.getResourceLimitMemory() : template.getResourceLimitMemory();
        ArrayList<ContainerEnvVar> combinedEnvVars = new ArrayList<ContainerEnvVar>();
        HashMap envVars = new HashMap();
        parent.getEnvVars().stream().filter(e -> !Strings.isNullOrEmpty((String)e.getKey())).forEach(e -> envVars.put(e.getKey(), e.getValue()));
        template.getEnvVars().stream().filter(e -> !Strings.isNullOrEmpty((String)e.getKey())).forEach(e -> envVars.put(e.getKey(), e.getValue()));
        envVars.entrySet().forEach(e -> combinedEnvVars.add(new ContainerEnvVar((String)e.getKey(), (String)e.getValue())));
        ContainerTemplate combined = new ContainerTemplate(image);
        combined.setName(name);
        combined.setImage(image);
        combined.setAlwaysPullImage(alwaysPullImage);
        combined.setCommand(command);
        combined.setArgs(args);
        combined.setTtyEnabled(ttyEnabled);
        combined.setResourceLimitCpu(resourceLimitCpu);
        combined.setResourceLimitMemory(resourceLimitMemory);
        combined.setResourceRequestCpu(resourceRequestCpu);
        combined.setResourceRequestMemory(resourceRequestMemory);
        combined.setWorkingDir(workingDir);
        combined.setPrivileged(privileged);
        combined.setEnvVars(combinedEnvVars);
        return combined;
    }

    public static PodTemplate combine(PodTemplate parent, PodTemplate template) {
        Preconditions.checkNotNull((Object)template, (Object)"Pod template should not be null");
        if (parent == null) {
            return template;
        }
        String name = template.getName();
        String label = template.getLabel();
        String nodeSelector = Strings.isNullOrEmpty((String)template.getNodeSelector()) ? parent.getNodeSelector() : template.getNodeSelector();
        String serviceAccount = Strings.isNullOrEmpty((String)template.getServiceAccount()) ? parent.getServiceAccount() : template.getServiceAccount();
        Node.Mode nodeUsageMode = template.getNodeUsageMode() == null ? parent.getNodeUsageMode() : template.getNodeUsageMode();
        LinkedHashSet<PodImagePullSecret> imagePullSecrets = new LinkedHashSet<PodImagePullSecret>();
        imagePullSecrets.addAll(parent.getImagePullSecrets());
        imagePullSecrets.addAll(template.getImagePullSecrets());
        HashMap<String, ContainerTemplate> combinedContainers = new HashMap<String, ContainerTemplate>();
        HashMap<String, PodVolume> combinedVolumes = new HashMap<String, PodVolume>();
        HashMap<String, String> combinedEnvVars = new HashMap<String, String>();
        combinedEnvVars.putAll(parent.getEnvVars().stream().filter(e -> !Strings.isNullOrEmpty((String)e.getKey())).collect(Collectors.toMap(e -> e.getKey(), e -> e.getValue())));
        combinedEnvVars.putAll(template.getEnvVars().stream().filter(e -> !Strings.isNullOrEmpty((String)e.getKey())).collect(Collectors.toMap(e -> e.getKey(), e -> e.getValue())));
        Map<String, ContainerTemplate> parentContainers = parent.getContainers().stream().collect(Collectors.toMap(c -> c.getName(), c -> c));
        combinedContainers.putAll(parentContainers);
        combinedContainers.putAll(template.getContainers().stream().collect(Collectors.toMap(c -> c.getName(), c -> PodTemplateUtils.combine((ContainerTemplate)parentContainers.get(c.getName()), c))));
        Map<String, PodVolume> parentVolumes = parent.getVolumes().stream().collect(Collectors.toMap(v -> v.getMountPath(), v -> v));
        combinedVolumes.putAll(parentVolumes);
        combinedVolumes.putAll(template.getVolumes().stream().collect(Collectors.toMap(v -> v.getMountPath(), v -> v)));
        WorkspaceVolume workspaceVolume = template.isCustomWorkspaceVolumeEnabled() && template.getWorkspaceVolume() != null ? template.getWorkspaceVolume() : parent.getWorkspaceVolume();
        ArrayList<ToolLocationNodeProperty> toolLocationNodeProperties = new ArrayList<ToolLocationNodeProperty>();
        toolLocationNodeProperties.addAll(parent.getNodeProperties());
        toolLocationNodeProperties.addAll(template.getNodeProperties());
        PodTemplate podTemplate = new PodTemplate();
        podTemplate.setName(name);
        podTemplate.setNamespace(!Strings.isNullOrEmpty((String)template.getNamespace()) ? template.getNamespace() : parent.getNamespace());
        podTemplate.setLabel(label);
        podTemplate.setNodeSelector(nodeSelector);
        podTemplate.setServiceAccount(serviceAccount);
        podTemplate.setEnvVars(combinedEnvVars.entrySet().stream().map(e -> new PodEnvVar((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()));
        podTemplate.setContainers(new ArrayList<ContainerTemplate>(combinedContainers.values()));
        podTemplate.setWorkspaceVolume(workspaceVolume);
        podTemplate.setVolumes(new ArrayList<PodVolume>(combinedVolumes.values()));
        podTemplate.setImagePullSecrets(new ArrayList<PodImagePullSecret>(imagePullSecrets));
        podTemplate.setNodeProperties(toolLocationNodeProperties);
        podTemplate.setNodeUsageMode(nodeUsageMode);
        return podTemplate;
    }

    static PodTemplate unwrap(PodTemplate template, String defaultProviderTemplate, Collection<PodTemplate> allTemplates) {
        String inheritFrom;
        if (template == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)defaultProviderTemplate)) {
            sb.append(defaultProviderTemplate).append(" ");
        }
        if (!Strings.isNullOrEmpty((String)template.getInheritFrom())) {
            sb.append(template.getInheritFrom()).append(" ");
        }
        if (Strings.isNullOrEmpty((String)(inheritFrom = sb.toString()))) {
            return template;
        }
        String[] parentNames = inheritFrom.split("[ ]+");
        PodTemplate parent = null;
        for (String name : parentNames) {
            PodTemplate next = PodTemplateUtils.getTemplateByName(name, allTemplates);
            if (next == null) continue;
            parent = PodTemplateUtils.combine(parent, PodTemplateUtils.unwrap(next, allTemplates));
        }
        return PodTemplateUtils.combine(parent, template);
    }

    static PodTemplate unwrap(PodTemplate template, Collection<PodTemplate> allTemplates) {
        return PodTemplateUtils.unwrap(template, null, allTemplates);
    }

    public static PodTemplate getTemplateByLabel(@CheckForNull Label label, Collection<PodTemplate> templates) {
        for (PodTemplate t : templates) {
            if ((label != null || t.getNodeUsageMode() != Node.Mode.NORMAL) && (label == null || !label.matches(t.getLabelSet()))) continue;
            return t;
        }
        return null;
    }

    public static PodTemplate getTemplateByName(@CheckForNull String name, Collection<PodTemplate> templates) {
        for (PodTemplate t : templates) {
            if (name == null || !name.equals(t.getName())) continue;
            return t;
        }
        return null;
    }

    public static String substituteEnv(String s) {
        return PodTemplateUtils.substitute(s, System.getenv());
    }

    public static String substituteEnv(String s, String defaultValue) {
        return PodTemplateUtils.substitute(s, System.getenv(), defaultValue);
    }

    public static String substitute(String s, Map<String, String> properties) {
        return PodTemplateUtils.substitute(s, properties, null);
    }

    public static String substitute(String s, Map<String, String> properties, String defaultValue) {
        if (Strings.isNullOrEmpty((String)s)) {
            return defaultValue;
        }
        Matcher m = PLACEHOLDER_PATTERN.matcher(s);
        while (m.find()) {
            String key = m.group(PLACEHOLDER_KEY);
            String val = properties.get(key);
            if (val != null) {
                s = s.replaceAll(String.format(PLACEHOLDER_FORMAT, key), Matcher.quoteReplacement(val));
                continue;
            }
            if (defaultValue == null) continue;
            s = s.replaceAll(String.format(PLACEHOLDER_FORMAT, key), defaultValue);
        }
        return s;
    }
}

