/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.csanchez.jenkins.plugins.kubernetes.ContainerEnvVar;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class PodEnvVar
extends AbstractDescribableImpl<PodEnvVar>
implements Serializable {
    private String key;
    private String value;

    @DataBoundConstructor
    public PodEnvVar(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.format("%s=%s", this.key, this.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PodEnvVar other = (PodEnvVar)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    static List<ContainerEnvVar> asContainerEnvVar(List<PodEnvVar> list) {
        return list.stream().map(var -> new ContainerEnvVar(var.getKey(), var.getValue())).collect(Collectors.toList());
    }

    static List<PodEnvVar> fromContainerEnvVar(List<ContainerEnvVar> list) {
        return list.stream().map(var -> new PodEnvVar(var.getKey(), var.getValue())).collect(Collectors.toList());
    }

    @Extension
    @Symbol(value={"podEnvVar"})
    public static class DescriptorImpl
    extends Descriptor<PodEnvVar> {
        public String getDisplayName() {
            return "Global Environment Variable (applied to all containers)";
        }
    }
}

