/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.labels.LabelAtom;
import hudson.security.ACL;
import hudson.slaves.Cloud;
import hudson.slaves.CloudRetentionStrategy;
import hudson.slaves.NodeProvisioner;
import hudson.slaves.RetentionStrategy;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.ExecAction;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.PrettyLoggable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import org.acegisecurity.Authentication;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.csanchez.jenkins.plugins.kubernetes.ContainerEnvVar;
import org.csanchez.jenkins.plugins.kubernetes.ContainerLivenessProbe;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesFactoryAdapter;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.csanchez.jenkins.plugins.kubernetes.PodAnnotation;
import org.csanchez.jenkins.plugins.kubernetes.PodEnvVar;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateUtils;
import org.csanchez.jenkins.plugins.kubernetes.TokenProducer;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.PodTemplateStepExecution;
import org.csanchez.jenkins.plugins.kubernetes.volumes.PodVolume;
import org.jenkinsci.plugins.durabletask.executors.OnceRetentionStrategy;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class KubernetesCloud
extends Cloud {
    private static final Logger LOGGER = Logger.getLogger(KubernetesCloud.class.getName());
    private static final Pattern SPLIT_IN_SPACES = Pattern.compile("([^\"]\\S*|\".+?\")\\s*");
    private static final String DEFAULT_ID = "jenkins/slave-default";
    private static final String WORKSPACE_VOLUME_NAME = "workspace-volume";
    public static final String JNLP_NAME = "jnlp";
    private static final String DEFAULT_JNLP_ARGUMENTS = "${computer.jnlpmac} ${computer.name}";
    private static final String DEFAULT_JNLP_IMAGE = System.getProperty(PodTemplateStepExecution.class.getName() + ".defaultImage", "jenkinsci/jnlp-slave:alpine");
    private static final Map<String, String> POD_LABEL = ImmutableMap.of((Object)"jenkins", (Object)"slave");
    private static final String JNLPMAC_REF = "\\$\\{computer.jnlpmac\\}";
    private static final String NAME_REF = "\\$\\{computer.name\\}";
    private static final int DEFAULT_RETENTION_TIMEOUT_MINUTES = 5;
    private String defaultsProviderTemplate;
    private List<PodTemplate> templates = new ArrayList<PodTemplate>();
    private String serverUrl;
    @CheckForNull
    private String serverCertificate;
    private boolean skipTlsVerify;
    private String namespace;
    private String jenkinsUrl;
    @CheckForNull
    private String jenkinsTunnel;
    @CheckForNull
    private String credentialsId;
    private int containerCap = Integer.MAX_VALUE;
    private int retentionTimeout = 5;
    private int connectTimeout;
    private int readTimeout;
    private transient KubernetesClient client;

    @DataBoundConstructor
    public KubernetesCloud(String name) {
        super(name);
    }

    @Deprecated
    public KubernetesCloud(String name, List<? extends PodTemplate> templates, String serverUrl, String namespace, String jenkinsUrl, String containerCapStr, int connectTimeout, int readTimeout, int retentionTimeout) {
        this(name);
        Preconditions.checkArgument((!StringUtils.isBlank((String)serverUrl) ? 1 : 0) != 0);
        this.setServerUrl(serverUrl);
        this.setNamespace(namespace);
        this.setJenkinsUrl(jenkinsUrl);
        if (templates != null) {
            this.templates.addAll(templates);
        }
        this.setContainerCapStr(containerCapStr);
        this.setRetentionTimeout(retentionTimeout);
        this.setConnectTimeout(connectTimeout);
        this.setReadTimeout(readTimeout);
    }

    public int getRetentionTimeout() {
        return this.retentionTimeout;
    }

    @DataBoundSetter
    public void setRetentionTimeout(int retentionTimeout) {
        this.retentionTimeout = retentionTimeout;
    }

    public String getDefaultsProviderTemplate() {
        return this.defaultsProviderTemplate;
    }

    @DataBoundSetter
    public void setDefaultsProviderTemplate(String defaultsProviderTemplate) {
        this.defaultsProviderTemplate = defaultsProviderTemplate;
    }

    public List<PodTemplate> getTemplates() {
        return this.templates;
    }

    @DataBoundSetter
    public void setTemplates(@Nonnull List<PodTemplate> templates) {
        this.templates = templates;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    @DataBoundSetter
    public void setServerUrl(@Nonnull String serverUrl) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)serverUrl) ? 1 : 0) != 0);
        this.serverUrl = serverUrl;
    }

    public String getServerCertificate() {
        return this.serverCertificate;
    }

    @DataBoundSetter
    public void setServerCertificate(String serverCertificate) {
        this.serverCertificate = Util.fixEmpty((String)serverCertificate);
    }

    public boolean isSkipTlsVerify() {
        return this.skipTlsVerify;
    }

    @DataBoundSetter
    public void setSkipTlsVerify(boolean skipTlsVerify) {
        this.skipTlsVerify = skipTlsVerify;
    }

    @CheckForNull
    public String getNamespace() {
        return this.namespace;
    }

    @DataBoundSetter
    public void setNamespace(String namespace) {
        this.namespace = Util.fixEmpty((String)namespace);
    }

    public String getJenkinsUrl() {
        return this.jenkinsUrl;
    }

    @DataBoundSetter
    public void setJenkinsUrl(String jenkinsUrl) {
        this.jenkinsUrl = jenkinsUrl;
    }

    public String getJenkinsTunnel() {
        return this.jenkinsTunnel;
    }

    @DataBoundSetter
    public void setJenkinsTunnel(String jenkinsTunnel) {
        this.jenkinsTunnel = Util.fixEmpty((String)jenkinsTunnel);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    public int getContainerCap() {
        return this.containerCap;
    }

    @DataBoundSetter
    public void setContainerCapStr(String containerCapStr) {
        this.containerCap = containerCapStr.equals("") ? Integer.MAX_VALUE : Integer.parseInt(containerCapStr);
    }

    public String getContainerCapStr() {
        if (this.containerCap == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.containerCap);
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC", "DC_DOUBLECHECK"})
    public KubernetesClient connect() throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, IOException, CertificateEncodingException {
        LOGGER.log(Level.FINE, "Building connection to Kubernetes host " + this.getDisplayName() + " URL " + this.serverUrl);
        if (this.client == null) {
            KubernetesCloud kubernetesCloud = this;
            synchronized (kubernetesCloud) {
                if (this.client == null) {
                    this.client = new KubernetesFactoryAdapter(this.serverUrl, this.namespace, this.serverCertificate, this.credentialsId, this.skipTlsVerify, this.connectTimeout, this.readTimeout).createClient();
                }
            }
        }
        return this.client;
    }

    private String getIdForLabel(Label label) {
        if (label == null) {
            return DEFAULT_ID;
        }
        return "jenkins/" + label.getName();
    }

    private Container createContainer(KubernetesSlave slave, ContainerTemplate containerTemplate, Collection<PodEnvVar> globalEnvVars, Collection<VolumeMount> volumeMounts) {
        String url;
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("JENKINS_SECRET", slave.getComputer().getJnlpMac());
        env.put("JENKINS_NAME", slave.getComputer().getName());
        JenkinsLocationConfiguration locationConfiguration = JenkinsLocationConfiguration.get();
        String locationConfigurationUrl = locationConfiguration != null ? locationConfiguration.getUrl() : null;
        String string = url = StringUtils.isBlank((String)this.jenkinsUrl) ? locationConfigurationUrl : this.jenkinsUrl;
        if (url == null) {
            throw new IllegalStateException("Jenkins URL is null while computing JNLP url");
        }
        env.put("JENKINS_LOCATION_URL", locationConfigurationUrl);
        env.put("JENKINS_URL", url);
        if (!StringUtils.isBlank((String)this.jenkinsTunnel)) {
            env.put("JENKINS_TUNNEL", this.jenkinsTunnel);
        }
        url = url.endsWith("/") ? url : url + "/";
        env.put("JENKINS_JNLP_URL", url + slave.getComputer().getUrl() + "slave-agent.jnlp");
        env.put("HOME", containerTemplate.getWorkingDir());
        if (globalEnvVars != null) {
            for (PodEnvVar podEnvVar : globalEnvVars) {
                env.put(podEnvVar.getKey(), PodTemplateUtils.substituteEnv(podEnvVar.getValue()));
            }
        }
        if (containerTemplate.getEnvVars() != null) {
            for (ContainerEnvVar containerEnvVar : containerTemplate.getEnvVars()) {
                env.put(containerEnvVar.getKey(), PodTemplateUtils.substituteEnv(containerEnvVar.getValue()));
            }
        }
        EnvVar[] envVars = (EnvVar[])env.entrySet().stream().map(entry -> new EnvVar((String)entry.getKey(), (String)entry.getValue(), null)).toArray(EnvVar[]::new);
        List arguments = Strings.isNullOrEmpty((String)containerTemplate.getArgs()) ? Collections.emptyList() : this.parseDockerCommand(containerTemplate.getArgs().replaceAll(JNLPMAC_REF, slave.getComputer().getJnlpMac()).replaceAll(NAME_REF, slave.getComputer().getName()));
        ArrayList<VolumeMount> containerMounts = new ArrayList<VolumeMount>(volumeMounts);
        ContainerPort[] ports = (ContainerPort[])containerTemplate.getPorts().stream().map(entry -> entry.toPort()).toArray(ContainerPort[]::new);
        if (!Strings.isNullOrEmpty((String)containerTemplate.getWorkingDir()) && !PodVolume.volumeMountExists(containerTemplate.getWorkingDir(), volumeMounts)) {
            containerMounts.add(new VolumeMount(containerTemplate.getWorkingDir(), WORKSPACE_VOLUME_NAME, Boolean.valueOf(false), null));
        }
        ContainerLivenessProbe clp = containerTemplate.getLivenessProbe();
        Probe livenessProbe = null;
        if (clp != null && this.parseLivenessProbe(clp.getExecArgs()) != null) {
            livenessProbe = ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)new ProbeBuilder().withExec(new ExecAction(this.parseLivenessProbe(clp.getExecArgs())))).withInitialDelaySeconds(Integer.valueOf(clp.getInitialDelaySeconds()))).withTimeoutSeconds(Integer.valueOf(clp.getTimeoutSeconds()))).withFailureThreshold(Integer.valueOf(clp.getFailureThreshold()))).withPeriodSeconds(Integer.valueOf(clp.getPeriodSeconds()))).withSuccessThreshold(Integer.valueOf(clp.getSuccessThreshold()))).build();
        }
        return ((ContainerBuilder)((ContainerFluent.ResourcesNested)((ContainerFluent.ResourcesNested)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerFluent.SecurityContextNested)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(PodTemplateUtils.substituteEnv(containerTemplate.getName()))).withImage(PodTemplateUtils.substituteEnv(containerTemplate.getImage()))).withImagePullPolicy(containerTemplate.isAlwaysPullImage() ? "Always" : "IfNotPresent")).withNewSecurityContext().withPrivileged(Boolean.valueOf(containerTemplate.isPrivileged()))).endSecurityContext()).withWorkingDir(PodTemplateUtils.substituteEnv(containerTemplate.getWorkingDir()))).withVolumeMounts(containerMounts.toArray(new VolumeMount[containerMounts.size()]))).addToEnv(envVars)).addToPorts(ports)).withCommand(this.parseDockerCommand(containerTemplate.getCommand()))).withArgs(arguments)).withLivenessProbe(livenessProbe)).withTty(Boolean.valueOf(containerTemplate.isTtyEnabled()))).withNewResources().withRequests(this.getResourcesMap(containerTemplate.getResourceRequestMemory(), containerTemplate.getResourceRequestCpu()))).withLimits(this.getResourcesMap(containerTemplate.getResourceLimitMemory(), containerTemplate.getResourceLimitCpu()))).endResources()).build();
    }

    private Pod getPodTemplate(KubernetesSlave slave, PodTemplate template) {
        if (template == null) {
            return null;
        }
        ArrayList<Volume> volumes = new ArrayList<Volume>();
        HashMap<String, VolumeMount> volumeMounts = new HashMap<String, VolumeMount>();
        int i = 0;
        for (PodVolume podVolume : template.getVolumes()) {
            String volumeName = "volume-" + i;
            String mountPath = PodTemplateUtils.substituteEnv(Paths.get(podVolume.getMountPath(), new String[0]).normalize().toString());
            if (volumeMounts.containsKey(mountPath)) continue;
            volumeMounts.put(mountPath, new VolumeMount(mountPath, volumeName, Boolean.valueOf(false), null));
            volumes.add(podVolume.buildVolume(volumeName));
            ++i;
        }
        if (template.getWorkspaceVolume() != null) {
            volumes.add(template.getWorkspaceVolume().buildVolume(WORKSPACE_VOLUME_NAME));
        } else {
            volumes.add(((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(WORKSPACE_VOLUME_NAME)).withNewEmptyDir("")).build());
        }
        HashMap<String, Container> containers = new HashMap<String, Container>();
        for (ContainerTemplate containerTemplate : template.getContainers()) {
            containers.put(containerTemplate.getName(), this.createContainer(slave, containerTemplate, template.getEnvVars(), volumeMounts.values()));
        }
        if (!containers.containsKey(JNLP_NAME)) {
            ContainerTemplate containerTemplate = new ContainerTemplate(DEFAULT_JNLP_IMAGE);
            containerTemplate.setName(JNLP_NAME);
            containerTemplate.setArgs(DEFAULT_JNLP_ARGUMENTS);
            containers.put(JNLP_NAME, this.createContainer(slave, containerTemplate, template.getEnvVars(), volumeMounts.values()));
        }
        List list = template.getImagePullSecrets().stream().map(x -> x.toLocalObjectReference()).collect(Collectors.toList());
        return ((PodBuilder)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(PodTemplateUtils.substituteEnv(slave.getNodeName()))).withLabels(this.getLabelsMap(template.getLabelSet()))).withAnnotations(this.getAnnotationsMap(template.getAnnotations()))).endMetadata()).withNewSpec().withVolumes(volumes)).withServiceAccount(PodTemplateUtils.substituteEnv(template.getServiceAccount()))).withImagePullSecrets(list)).withContainers(containers.values().toArray(new Container[containers.size()]))).withNodeSelector(this.getNodeSelectorMap(template.getNodeSelector()))).withRestartPolicy("Never")).endSpec()).build();
    }

    private Map<String, String> getLabelsMap(Set<LabelAtom> labelSet) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(POD_LABEL);
        if (!labelSet.isEmpty()) {
            for (LabelAtom label : labelSet) {
                builder.put((Object)this.getIdForLabel((Label)label), (Object)"true");
            }
        }
        return builder.build();
    }

    private Map<String, Quantity> getResourcesMap(String memory, String cpu) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String actualMemory = PodTemplateUtils.substituteEnv(memory, null);
        String actualCpu = PodTemplateUtils.substituteEnv(cpu, null);
        if (StringUtils.isNotBlank((String)actualMemory)) {
            Quantity memoryQuantity = new Quantity(actualMemory);
            builder.put((Object)"memory", (Object)memoryQuantity);
        }
        if (StringUtils.isNotBlank((String)actualCpu)) {
            Quantity cpuQuantity = new Quantity(actualCpu);
            builder.put((Object)"cpu", (Object)cpuQuantity);
        }
        return builder.build();
    }

    private Map<String, String> getAnnotationsMap(List<PodAnnotation> annotations) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (annotations != null) {
            for (PodAnnotation podAnnotation : annotations) {
                builder.put((Object)podAnnotation.getKey(), (Object)PodTemplateUtils.substituteEnv(podAnnotation.getValue()));
            }
        }
        return builder.build();
    }

    private Map<String, String> getNodeSelectorMap(String selectors) {
        if (Strings.isNullOrEmpty((String)selectors)) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String selector : selectors.split(",")) {
            String[] parts = selector.split("=");
            if (parts.length == 2 && !parts[0].isEmpty() && !parts[1].isEmpty()) {
                builder = builder.put((Object)parts[0], (Object)PodTemplateUtils.substituteEnv(parts[1]));
                continue;
            }
            LOGGER.log(Level.WARNING, "Ignoring selector '" + selector + "'. Selectors must be in the format 'label1=value1,label2=value2'.");
        }
        return builder.build();
    }

    List<String> parseDockerCommand(String dockerCommand) {
        if (dockerCommand == null || dockerCommand.isEmpty()) {
            return null;
        }
        Matcher m = SPLIT_IN_SPACES.matcher(dockerCommand);
        ArrayList<String> commands = new ArrayList<String>();
        while (m.find()) {
            commands.add(PodTemplateUtils.substituteEnv(m.group(1).replace("\"", "")));
        }
        return commands;
    }

    List<String> parseLivenessProbe(String livenessProbeExec) {
        if (StringUtils.isBlank((String)livenessProbeExec)) {
            return null;
        }
        Matcher m = SPLIT_IN_SPACES.matcher(livenessProbeExec);
        ArrayList<String> commands = new ArrayList<String>();
        while (m.find()) {
            commands.add(PodTemplateUtils.substituteEnv(m.group(1).replace("\"", "").replace("?:\\\"", "")));
        }
        return commands;
    }

    public synchronized Collection<NodeProvisioner.PlannedNode> provision(@CheckForNull Label label, int excessWorkload) {
        try {
            LOGGER.log(Level.INFO, "Excess workload after pending Spot instances: " + excessWorkload);
            ArrayList<NodeProvisioner.PlannedNode> r = new ArrayList<NodeProvisioner.PlannedNode>();
            ArrayList<PodTemplate> templates = this.getMatchingTemplates(label);
            for (PodTemplate t : templates) {
                LOGGER.log(Level.INFO, "Template: " + t.getDisplayName());
                for (int i = 1; i <= excessWorkload && this.addProvisionedSlave(t, label); ++i) {
                    r.add(new NodeProvisioner.PlannedNode(t.getDisplayName(), Computer.threadPoolForRemoting.submit(new ProvisioningCallback(this, t, label)), 1));
                }
                if (r.size() <= 0) continue;
                return r;
            }
            return r;
        }
        catch (KubernetesClientException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SocketTimeoutException || cause instanceof ConnectException) {
                LOGGER.log(Level.WARNING, "Failed to connect to Kubernetes at {0}: {1}", new String[]{this.serverUrl, cause.getMessage()});
            } else {
                LOGGER.log(Level.WARNING, "Failed to count the # of live instances on Kubernetes", cause != null ? cause : e);
            }
        }
        catch (ConnectException e) {
            LOGGER.log(Level.WARNING, "Failed to connect to Kubernetes at {0}", this.serverUrl);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to count the # of live instances on Kubernetes", e);
        }
        return Collections.emptyList();
    }

    private boolean addProvisionedSlave(@Nonnull PodTemplate template, @CheckForNull Label label) throws Exception {
        if (this.containerCap == 0) {
            return true;
        }
        KubernetesClient client = this.connect();
        PodList slaveList = (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace(template.getNamespace())).withLabels(POD_LABEL)).list();
        List slaveListItems = slaveList.getItems();
        Map<String, String> labelsMap = this.getLabelsMap(template.getLabelSet());
        PodList namedList = (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace(template.getNamespace())).withLabels(labelsMap)).list();
        List namedListItems = namedList.getItems();
        if (slaveListItems != null && this.containerCap <= slaveListItems.size()) {
            LOGGER.log(Level.INFO, "Total container cap of {0} reached, not provisioning: {1} running in namespace {2}", new Object[]{this.containerCap, slaveListItems.size(), client.getNamespace()});
            return false;
        }
        if (namedListItems != null && slaveListItems != null && template.getInstanceCap() <= namedListItems.size()) {
            LOGGER.log(Level.INFO, "Template instance cap of {0} reached for template {1}, not provisioning: {2} running in namespace '{3}' with label '{4}'", new Object[]{template.getInstanceCap(), template.getName(), slaveListItems.size(), client.getNamespace(), label == null ? "" : label.toString()});
            return false;
        }
        return true;
    }

    public boolean canProvision(@CheckForNull Label label) {
        return this.getTemplate(label) != null;
    }

    public PodTemplate getTemplate(@CheckForNull Label label) {
        return PodTemplateUtils.getTemplateByLabel(label, this.templates);
    }

    public ArrayList<PodTemplate> getMatchingTemplates(@CheckForNull Label label) {
        ArrayList<PodTemplate> podList = new ArrayList<PodTemplate>();
        for (PodTemplate t : this.templates) {
            if ((label != null || t.getNodeUsageMode() != Node.Mode.NORMAL) && (label == null || !label.matches(t.getLabelSet()))) continue;
            podList.add(t);
        }
        return podList;
    }

    public void addTemplate(PodTemplate t) {
        this.templates.add(t);
    }

    public void removeTemplate(PodTemplate t) {
        this.templates.remove(t);
    }

    public String toString() {
        return String.format("KubernetesCloud name: %s serverUrl: %s", this.name, this.serverUrl);
    }

    private Object readResolve() {
        if (this.serverCertificate != null && !this.serverCertificate.trim().startsWith("-----BEGIN CERTIFICATE-----")) {
            this.serverCertificate = new String(Base64.decodeBase64((byte[])this.serverCertificate.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            LOGGER.log(Level.INFO, "Upgraded Kubernetes server certificate key: {0}", this.serverCertificate.substring(0, 80));
        }
        return this;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Cloud> {
        public String getDisplayName() {
            return "Kubernetes";
        }

        public FormValidation doTestConnection(@QueryParameter String name, @QueryParameter String serverUrl, @QueryParameter String credentialsId, @QueryParameter String serverCertificate, @QueryParameter boolean skipTlsVerify, @QueryParameter String namespace, @QueryParameter int connectionTimeout, @QueryParameter int readTimeout) throws Exception {
            if (StringUtils.isBlank((String)serverUrl)) {
                return FormValidation.error((String)"URL is required");
            }
            if (StringUtils.isBlank((String)name)) {
                return FormValidation.error((String)"name is required");
            }
            try {
                KubernetesClient client = new KubernetesFactoryAdapter(serverUrl, namespace, Util.fixEmpty((String)serverCertificate), Util.fixEmpty((String)credentialsId), skipTlsVerify, connectionTimeout, readTimeout).createClient();
                client.pods().list();
                return FormValidation.ok((String)"Connection successful");
            }
            catch (KubernetesClientException e) {
                LOGGER.log(Level.FINE, String.format("Error connecting to %s", serverUrl), e);
                return FormValidation.error((String)"Error connecting to %s: %s", (Object[])new Object[]{serverUrl, e.getCause() == null ? e.getMessage() : String.format("%s: %s", e.getCause().getClass().getName(), e.getCause().getMessage())});
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, String.format("Error connecting to %s", serverUrl), e);
                return FormValidation.error((String)"Error connecting to %s: %s", (Object[])new Object[]{serverUrl, e.getMessage()});
            }
        }

        public ListBoxModel doFillCredentialsIdItems(@QueryParameter String serverUrl) {
            return new StandardListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(TokenProducer.class), CredentialsMatchers.instanceOf(StandardCertificateCredentials.class)}), (Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (List)(serverUrl != null ? URIRequirementBuilder.fromUri((String)serverUrl).build() : Collections.EMPTY_LIST)));
        }
    }

    private class ProvisioningCallback
    implements Callable<Node> {
        @Nonnull
        private final KubernetesCloud cloud;
        @Nonnull
        private final PodTemplate t;
        @CheckForNull
        private final Label label;

        public ProvisioningCallback(@Nonnull KubernetesCloud cloud, @CheckForNull PodTemplate t, Label label) {
            this.cloud = cloud;
            this.t = t;
            this.label = label;
        }

        private void logLastLines(List<ContainerStatus> containers, String podId, String namespace, KubernetesSlave slave, Map<String, Integer> errors) {
            for (ContainerStatus containerStatus : containers) {
                String containerName = containerStatus.getName();
                try {
                    PrettyLoggable tailingLines = (PrettyLoggable)((ContainerResource)((PodResource)((NonNamespaceOperation)KubernetesCloud.this.connect().pods().inNamespace(namespace)).withName(podId)).inContainer((Object)containerStatus.getName())).tailingLines(30);
                    String log = (String)tailingLines.getLog();
                    if (StringUtils.isBlank((String)log)) continue;
                    String msg = errors != null ? String.format(" exited with error %s", errors.get(containerName)) : "";
                    LOGGER.log(Level.SEVERE, "Error in provisioning; slave={0}, template={1}. Container {2}{3}. Logs: {4}", new Object[]{slave, this.t, containerName, msg, tailingLines.getLog()});
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateEncodingException e) {
                    LOGGER.log(Level.SEVERE, "Could not get logs for pod " + podId, e);
                }
            }
        }

        @Override
        public Node call() throws Exception {
            KubernetesSlave slave = null;
            Object retentionStrategy = null;
            try {
                String status;
                int i;
                retentionStrategy = this.t.getIdleMinutes() == 0 ? new OnceRetentionStrategy(this.cloud.getRetentionTimeout()) : new CloudRetentionStrategy(this.t.getIdleMinutes());
                PodTemplate unwrappedTemplate = PodTemplateUtils.unwrap(KubernetesCloud.this.getTemplate(this.label), KubernetesCloud.this.defaultsProviderTemplate, KubernetesCloud.this.templates);
                slave = new KubernetesSlave(unwrappedTemplate, unwrappedTemplate.getName(), this.cloud.name, unwrappedTemplate.getLabel(), (RetentionStrategy)retentionStrategy);
                LOGGER.log(Level.FINER, "Adding Jenkins node: {0}", slave.getNodeName());
                Jenkins.getActiveInstance().addNode((Node)slave);
                KubernetesClient client = KubernetesCloud.this.connect();
                Pod pod = KubernetesCloud.this.getPodTemplate(slave, unwrappedTemplate);
                String podId = pod.getMetadata().getName();
                String namespace = Strings.isNullOrEmpty((String)this.t.getNamespace()) ? client.getNamespace() : this.t.getNamespace();
                pod = (Pod)((NonNamespaceOperation)client.pods().inNamespace(namespace)).create((Object[])new Pod[]{pod});
                LOGGER.log(Level.INFO, "Created Pod: {0}", podId);
                ImmutableList validStates = ImmutableList.of((Object)"Running");
                int j = 100;
                List containerStatuses = null;
                for (i = 0; i < j; ++i) {
                    LOGGER.log(Level.INFO, "Waiting for Pod to be scheduled ({1}/{2}): {0}", new Object[]{podId, i, j});
                    Thread.sleep(6000L);
                    pod = (Pod)((PodResource)((NonNamespaceOperation)KubernetesCloud.this.connect().pods().inNamespace(namespace)).withName(podId)).get();
                    if (pod == null) {
                        throw new IllegalStateException("Pod no longer exists: " + podId);
                    }
                    containerStatuses = pod.getStatus().getContainerStatuses();
                    ArrayList<ContainerStatus> terminatedContainers = new ArrayList<ContainerStatus>();
                    Boolean allContainersAreReady = true;
                    for (ContainerStatus info2 : containerStatuses) {
                        if (info2 == null) continue;
                        if (info2.getState().getWaiting() != null) {
                            LOGGER.log(Level.INFO, "Container is waiting {0} [{2}]: {1}", new Object[]{podId, info2.getState().getWaiting(), info2.getName()});
                        }
                        if (info2.getState().getTerminated() != null) {
                            terminatedContainers.add(info2);
                            continue;
                        }
                        if (info2.getReady().booleanValue()) continue;
                        allContainersAreReady = false;
                    }
                    if (!terminatedContainers.isEmpty()) {
                        Map<String, Integer> errors = terminatedContainers.stream().collect(Collectors.toMap(ContainerStatus::getName, info -> info.getState().getTerminated().getExitCode()));
                        this.logLastLines(terminatedContainers, podId, namespace, slave, errors);
                        throw new IllegalStateException("Containers are terminated with exit codes: " + errors);
                    }
                    if (allContainersAreReady.booleanValue() && validStates.contains((Object)pod.getStatus().getPhase())) break;
                }
                if (!validStates.contains((Object)(status = pod.getStatus().getPhase()))) {
                    throw new IllegalStateException("Container is not running after " + j + " attempts, status: " + status);
                }
                j = this.t.getSlaveConnectTimeout();
                while (i < j) {
                    if (slave.getComputer() == null) {
                        throw new IllegalStateException("Node was deleted, computer is null");
                    }
                    if (slave.getComputer().isOnline()) break;
                    LOGGER.log(Level.INFO, "Waiting for slave to connect ({1}/{2}): {0}", new Object[]{podId, i, j});
                    Thread.sleep(1000L);
                    ++i;
                }
                if (!slave.getComputer().isOnline()) {
                    if (containerStatuses != null) {
                        this.logLastLines(containerStatuses, podId, namespace, slave, null);
                    }
                    throw new IllegalStateException("Slave is not connected after " + j + " attempts, status: " + status);
                }
                return slave;
            }
            catch (Throwable ex) {
                LOGGER.log(Level.SEVERE, "Error in provisioning; slave={0}, template={1}: {2}", new Object[]{slave, this.t, ex.getMessage()});
                if (slave != null) {
                    LOGGER.log(Level.FINER, "Removing Jenkins node: {0}", slave.getNodeName());
                    Jenkins.getInstance().removeNode(slave);
                }
                throw Throwables.propagate((Throwable)ex);
            }
        }
    }
}

