/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.google.common.base.Preconditions;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.csanchez.jenkins.plugins.kubernetes.ContainerEnvVar;
import org.csanchez.jenkins.plugins.kubernetes.ContainerLivenessProbe;
import org.csanchez.jenkins.plugins.kubernetes.PortMapping;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ContainerTemplate
extends AbstractDescribableImpl<ContainerTemplate>
implements Serializable {
    private static final long serialVersionUID = 4212681620316294146L;
    public static final String DEFAULT_WORKING_DIR = "/home/jenkins";
    private String name;
    private String image;
    private boolean privileged;
    private boolean alwaysPullImage;
    private String workingDir = "/home/jenkins";
    private String command;
    private String args;
    private boolean ttyEnabled;
    private String resourceRequestCpu;
    private String resourceRequestMemory;
    private String resourceLimitCpu;
    private String resourceLimitMemory;
    private final List<ContainerEnvVar> envVars = new ArrayList<ContainerEnvVar>();
    private List<PortMapping> ports = new ArrayList<PortMapping>();
    private ContainerLivenessProbe livenessProbe;

    @Deprecated
    public ContainerTemplate(String image) {
        this(null, image);
    }

    @DataBoundConstructor
    public ContainerTemplate(String name, String image) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)image) ? 1 : 0) != 0);
        this.name = name;
        this.image = image;
    }

    public ContainerTemplate(String name, String image, String command, String args) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)image) ? 1 : 0) != 0);
        this.name = name;
        this.image = image;
        this.command = command;
        this.args = args;
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @DataBoundSetter
    public void setImage(String image) {
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    @DataBoundSetter
    public void setCommand(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    @DataBoundSetter
    public void setArgs(String args) {
        this.args = args;
    }

    public String getArgs() {
        return this.args;
    }

    @DataBoundSetter
    public void setTtyEnabled(boolean ttyEnabled) {
        this.ttyEnabled = ttyEnabled;
    }

    public boolean isTtyEnabled() {
        return this.ttyEnabled;
    }

    public String getDisplayName() {
        return "Container Pod Template";
    }

    @DataBoundSetter
    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    @DataBoundSetter
    public void setPrivileged(boolean privileged) {
        this.privileged = privileged;
    }

    public boolean isPrivileged() {
        return this.privileged;
    }

    @DataBoundSetter
    public void setAlwaysPullImage(boolean alwaysPullImage) {
        this.alwaysPullImage = alwaysPullImage;
    }

    public boolean isAlwaysPullImage() {
        return this.alwaysPullImage;
    }

    public List<ContainerEnvVar> getEnvVars() {
        return this.envVars != null ? this.envVars : Collections.emptyList();
    }

    @DataBoundSetter
    public void setEnvVars(List<ContainerEnvVar> envVars) {
        this.envVars.addAll(envVars);
    }

    public ContainerLivenessProbe getLivenessProbe() {
        return this.livenessProbe;
    }

    @DataBoundSetter
    public void setLivenessProbe(ContainerLivenessProbe livenessProbe) {
        this.livenessProbe = livenessProbe;
    }

    public List<PortMapping> getPorts() {
        return this.ports != null ? this.ports : Collections.emptyList();
    }

    @DataBoundSetter
    public void setPorts(List<PortMapping> ports) {
        this.ports = ports;
    }

    public String getResourceRequestMemory() {
        return this.resourceRequestMemory;
    }

    @DataBoundSetter
    public void setResourceRequestMemory(String resourceRequestMemory) {
        this.resourceRequestMemory = resourceRequestMemory;
    }

    public String getResourceLimitCpu() {
        return this.resourceLimitCpu;
    }

    @DataBoundSetter
    public void setResourceLimitCpu(String resourceLimitCpu) {
        this.resourceLimitCpu = resourceLimitCpu;
    }

    public String getResourceLimitMemory() {
        return this.resourceLimitMemory;
    }

    @DataBoundSetter
    public void setResourceLimitMemory(String resourceLimitMemory) {
        this.resourceLimitMemory = resourceLimitMemory;
    }

    public String getResourceRequestCpu() {
        return this.resourceRequestCpu;
    }

    @DataBoundSetter
    public void setResourceRequestCpu(String resourceRequestCpu) {
        this.resourceRequestCpu = resourceRequestCpu;
    }

    @Extension
    @Symbol(value={"containerTemplate"})
    public static class DescriptorImpl
    extends Descriptor<ContainerTemplate> {
        public String getDisplayName() {
            return "Container Template";
        }
    }
}

