/*
 * Copyright 2012 Jacob D Parr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.crazyyak.dev.net.google.maps.directions;

import com.fasterxml.jackson.annotation.*;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Route {

  private String summary;
  private Leg[] legs;
  // private WayPointOrder waypoint_order
  // overview_polyline
  // bounds
  private String copyrights;
  private String[] warnings;

  public Route() {
  }

  public String getSummary() {
    return summary;
  }

  public Leg[] getLegs() {
    return legs;
  }

  public Leg getFirstLeg() {
    return (legs == null || legs.length == 0) ? null : legs[0];
  }

/*
  public String getCopyrights() {
    return copyrights;
  }

  public String[] getWarnings() {
    return warnings;
  }
*/
}
