/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.shiro;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.crazycake.shiro.IRedisManager;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

public abstract class WorkAloneRedisManager
implements IRedisManager {
    protected static final int DEFAULT_COUNT = 100;
    private int count = 100;
    private JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();

    protected abstract Jedis getJedis();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(byte[] key) {
        if (key == null) {
            return null;
        }
        byte[] value = null;
        Jedis jedis = this.getJedis();
        try {
            value = jedis.get(key);
        }
        finally {
            jedis.close();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] set(byte[] key, byte[] value, int expireTime) {
        if (key == null) {
            return null;
        }
        Jedis jedis = this.getJedis();
        try {
            jedis.set(key, value);
            if (expireTime > 0) {
                jedis.expire(key, expireTime);
            }
        }
        finally {
            jedis.close();
        }
        return value;
    }

    @Override
    public void del(byte[] key) {
        if (key == null) {
            return;
        }
        Jedis jedis = this.getJedis();
        try {
            jedis.del(key);
        }
        finally {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long dbSize(byte[] pattern) {
        long dbSize = 0L;
        Jedis jedis = this.getJedis();
        try {
            ScanResult scanResult;
            ScanParams params = new ScanParams();
            params.count(Integer.valueOf(this.count));
            params.match(pattern);
            byte[] cursor = ScanParams.SCAN_POINTER_START_BINARY;
            do {
                scanResult = jedis.scan(cursor, params);
                List results = scanResult.getResult();
                for (byte[] result : results) {
                    ++dbSize;
                }
                cursor = scanResult.getCursorAsBytes();
            } while (scanResult.getStringCursor().compareTo(ScanParams.SCAN_POINTER_START) > 0);
        }
        finally {
            jedis.close();
        }
        return dbSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> keys(byte[] pattern) {
        HashSet<byte[]> keys = new HashSet<byte[]>();
        Jedis jedis = this.getJedis();
        try {
            ScanResult scanResult;
            ScanParams params = new ScanParams();
            params.count(Integer.valueOf(this.count));
            params.match(pattern);
            byte[] cursor = ScanParams.SCAN_POINTER_START_BINARY;
            do {
                scanResult = jedis.scan(cursor, params);
                keys.addAll(scanResult.getResult());
                cursor = scanResult.getCursorAsBytes();
            } while (scanResult.getStringCursor().compareTo(ScanParams.SCAN_POINTER_START) > 0);
        }
        finally {
            jedis.close();
        }
        return keys;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public JedisPoolConfig getJedisPoolConfig() {
        return this.jedisPoolConfig;
    }

    public void setJedisPoolConfig(JedisPoolConfig jedisPoolConfig) {
        this.jedisPoolConfig = jedisPoolConfig;
    }
}

