/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.auth;

import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.util.SecurityUtils;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.crsh.ssh.util.KeyPairUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FilePublicKeyProvider
extends AbstractKeyPairProvider {
    private static final Logger LOG = LoggerFactory.getLogger(FilePublicKeyProvider.class);
    private String[] files;

    FilePublicKeyProvider(String[] files) {
        this.files = files;
    }

    public Iterable<KeyPair> loadKeys() {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            throw new IllegalStateException("BouncyCastle must be registered as a JCE provider");
        }
        ArrayList<KeyPair> keys = new ArrayList<KeyPair>();
        for (String file : this.files) {
            try {
                Object o = KeyPairUtils.readKey(new InputStreamReader(new FileInputStream(file)));
                if (o instanceof KeyPair) {
                    keys.add(new KeyPair(((KeyPair)o).getPublic(), null));
                    continue;
                }
                if (o instanceof PublicKey) {
                    keys.add(new KeyPair((PublicKey)o, null));
                    continue;
                }
                if (!(o instanceof PEMKeyPair)) continue;
                PEMKeyPair keyPair = (PEMKeyPair)o;
                JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
                keys.add(new KeyPair(converter.getPublicKey(keyPair.getPublicKeyInfo()), null));
            }
            catch (Exception e) {
                LOG.info("Unable to read key {}: {}", (Object)file, (Object)e);
            }
        }
        return keys;
    }
}

