/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.search.service.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.lang.UrlUtils;
import org.craftercms.core.service.Content;
import org.craftercms.search.exception.SearchException;
import org.craftercms.search.service.Query;
import org.craftercms.search.service.SearchService;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

public class RestClientSearchService
implements SearchService {
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    protected String serverUrl;
    protected RestTemplate restTemplate;
    protected Charset charset = DEFAULT_CHARSET;

    public RestClientSearchService() {
        this.restTemplate = this.createRestTemplate();
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    @Required
    public void setServerUrl(String serverUrl) {
        this.serverUrl = StringUtils.stripEnd((String)serverUrl, (String)"/");
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setCharset(String charset) {
        this.charset = Charset.forName(charset);
    }

    public Map<String, Object> search(Query query) throws SearchException {
        return this.search(null, query);
    }

    public Map<String, Object> search(String indexId, Query query) throws SearchException {
        String searchUrl = this.createBaseUrl("/search", indexId);
        searchUrl = UrlUtils.addQueryStringFragment((String)searchUrl, (String)query.toQueryString());
        try {
            return (Map)this.restTemplate.getForObject(new URI(searchUrl.toString()), Map.class);
        }
        catch (URISyntaxException e) {
            throw new SearchException(indexId, "Invalid URI: " + searchUrl, (Throwable)e);
        }
        catch (HttpStatusCodeException e) {
            throw new SearchException(indexId, "Search for query " + query + " failed: [" + e.getStatusText() + "] " + e.getResponseBodyAsString());
        }
        catch (Exception e) {
            throw new SearchException(indexId, "Search for query " + query + " failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public String update(String site, String id, String xml, boolean ignoreRootInFieldNames) throws SearchException {
        return this.update(null, site, id, xml, ignoreRootInFieldNames);
    }

    public String update(String indexId, String site, String id, String xml, boolean ignoreRootInFieldNames) throws SearchException {
        String updateUrl = this.createBaseUrl("/update", indexId);
        updateUrl = this.addParam(updateUrl, "site", site);
        updateUrl = this.addParam(updateUrl, "id", id);
        updateUrl = this.addParam(updateUrl, "stripRoot", ignoreRootInFieldNames);
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(new MediaType("text", "xml", this.charset));
            return (String)this.restTemplate.postForObject(new URI(updateUrl), (Object)new HttpEntity((Object)xml, (MultiValueMap)headers), String.class);
        }
        catch (URISyntaxException e) {
            throw new SearchException(indexId, "Invalid URI: " + updateUrl, (Throwable)e);
        }
        catch (HttpStatusCodeException e) {
            throw new SearchException(indexId, "Update for XML '" + id + "' failed: [" + e.getStatusText() + "] " + e.getResponseBodyAsString());
        }
        catch (Exception e) {
            throw new SearchException(indexId, "Update for XML '" + id + "' failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public String delete(String site, String id) throws SearchException {
        return this.delete(null, site, id);
    }

    public String delete(String indexId, String site, String id) throws SearchException {
        String deleteUrl = this.createBaseUrl("/delete", indexId);
        deleteUrl = this.addParam(deleteUrl, "site", site);
        deleteUrl = this.addParam(deleteUrl, "id", id);
        try {
            return (String)this.restTemplate.postForObject(new URI(deleteUrl), null, String.class);
        }
        catch (URISyntaxException e) {
            throw new SearchException(indexId, "Invalid URI: " + deleteUrl, (Throwable)e);
        }
        catch (HttpStatusCodeException e) {
            throw new SearchException(indexId, "Delete for XML '" + id + "' failed: [" + e.getStatusText() + "] " + e.getResponseBodyAsString());
        }
        catch (Exception e) {
            throw new SearchException(indexId, "Delete for XML '" + id + "' failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public String commit() throws SearchException {
        return this.commit(null);
    }

    public String commit(String indexId) throws SearchException {
        String commitUrl = this.createBaseUrl("/commit", indexId);
        try {
            return (String)this.restTemplate.postForObject(new URI(commitUrl), null, String.class);
        }
        catch (URISyntaxException e) {
            throw new SearchException(indexId, "Invalid URI: " + commitUrl, (Throwable)e);
        }
        catch (HttpStatusCodeException e) {
            throw new SearchException(indexId, "Commit failed: [" + e.getStatusText() + "] " + e.getResponseBodyAsString());
        }
        catch (Exception e) {
            throw new SearchException(indexId, "Commit failed: " + e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    public String updateDocument(String site, String id, File document) throws SearchException {
        return this.updateDocument(site, id, document, null);
    }

    @Deprecated
    public String updateDocument(String site, String id, File document, Map<String, String> additionalFields) throws SearchException {
        FileSystemResource fsr = new FileSystemResource(document);
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"site", (Object)site);
        form.add((Object)"id", (Object)id);
        form.add((Object)"document", (Object)fsr);
        if (MapUtils.isNotEmpty(additionalFields)) {
            for (Map.Entry<String, String> additionalField : additionalFields.entrySet()) {
                String fieldName = additionalField.getKey();
                if (fieldName.equals("site") || fieldName.equals("id") || fieldName.equals("document")) {
                    throw new SearchException(String.format("An additional field shouldn't have the following names: %s, %s, %s", "site", "id", "document"));
                }
                form.add((Object)fieldName, (Object)additionalField.getValue());
            }
        }
        String updateDocumentUrl = this.createBaseUrl("/update-document");
        try {
            return (String)this.restTemplate.postForObject(new URI(updateDocumentUrl), (Object)form, String.class);
        }
        catch (URISyntaxException e) {
            throw new SearchException("Invalid URI: " + updateDocumentUrl, (Throwable)e);
        }
        catch (HttpStatusCodeException e) {
            throw new SearchException("Update for document '" + id + "' failed: [" + e.getStatusText() + "] " + e.getResponseBodyAsString());
        }
        catch (Exception e) {
            throw new SearchException("Update for document '" + id + "' failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public String updateFile(String site, String id, File file) throws SearchException {
        return this.updateFile(null, site, id, file, null);
    }

    public String updateFile(String indexId, String site, String id, File file) throws SearchException {
        return this.updateFile(indexId, site, id, file, null);
    }

    public String updateFile(String site, String id, File file, Map<String, List<String>> additionalFields) throws SearchException {
        return this.updateFile(null, site, id, file, additionalFields);
    }

    public String updateFile(String indexId, String site, String id, File file, Map<String, List<String>> additionalFields) throws SearchException {
        return this.updateFile(indexId, site, id, (Resource)new FileSystemResource(file), additionalFields);
    }

    public String updateFile(String site, String id, Content content) throws SearchException {
        return this.updateFile(null, site, id, content, null);
    }

    public String updateFile(String indexId, String site, String id, Content content) throws SearchException {
        return this.updateFile(indexId, site, id, content, null);
    }

    public String updateFile(String site, String id, Content content, Map<String, List<String>> additionalFields) throws SearchException {
        return this.updateFile(null, site, id, content, additionalFields);
    }

    public String updateFile(String indexId, String site, String id, Content content, Map<String, List<String>> additionalFields) throws SearchException {
        String filename = FilenameUtils.getName((String)id);
        ContentResource resource = new ContentResource(content, filename);
        return this.updateFile(indexId, site, id, (Resource)resource, additionalFields);
    }

    protected String updateFile(String indexId, String site, String id, Resource resource, Map<String, List<String>> additionalFields) throws SearchException {
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        if (StringUtils.isNotEmpty((CharSequence)indexId)) {
            form.set((Object)"indexId", (Object)indexId);
        }
        form.set((Object)"site", (Object)site);
        form.set((Object)"id", (Object)id);
        form.set((Object)"document", (Object)resource);
        if (MapUtils.isNotEmpty(additionalFields)) {
            for (Map.Entry<String, List<String>> additionalField : additionalFields.entrySet()) {
                String fieldName = additionalField.getKey();
                if (fieldName.equals("indexId") || fieldName.equals("site") || fieldName.equals("id") || fieldName.endsWith("document")) {
                    throw new SearchException(String.format("An additional field shouldn't have the following names: %s, %s, %s, %s", "indexId", "site", "id", "document"));
                }
                form.put((Object)fieldName, additionalField.getValue());
            }
        }
        String updateUrl = this.createBaseUrl("/update-file");
        try {
            return (String)this.restTemplate.postForObject(new URI(updateUrl), (Object)form, String.class);
        }
        catch (URISyntaxException e) {
            throw new SearchException(indexId, "Invalid URI: " + updateUrl, (Throwable)e);
        }
        catch (HttpStatusCodeException e) {
            throw new SearchException(indexId, "Update for file '" + id + "' failed: [" + e.getStatusText() + "] " + e.getResponseBodyAsString());
        }
        catch (Exception e) {
            throw new SearchException(indexId, "Update for file '" + id + "' failed: " + e.getMessage(), (Throwable)e);
        }
    }

    protected String createBaseUrl(String serviceUrl) {
        return this.serverUrl + "/api/1/search" + serviceUrl;
    }

    protected String createBaseUrl(String serviceUrl, String indexId) {
        String url = this.createBaseUrl(serviceUrl);
        if (StringUtils.isNotEmpty((CharSequence)indexId)) {
            url = this.addParam(url, "indexId", indexId);
        }
        return url;
    }

    protected String addParam(String url, String name, Object value) {
        try {
            return UrlUtils.addParam((String)url, (String)name, (String)value.toString(), (String)"UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException();
        }
    }

    protected RestTemplate createRestTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        for (HttpMessageConverter converter : restTemplate.getMessageConverters()) {
            if (!(converter instanceof FormHttpMessageConverter)) continue;
            StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter(this.charset);
            stringHttpMessageConverter.setWriteAcceptCharset(false);
            ArrayList<Object> partConverters = new ArrayList<Object>();
            partConverters.add(new ByteArrayHttpMessageConverter());
            partConverters.add(stringHttpMessageConverter);
            partConverters.add(new ResourceHttpMessageConverter());
            ((FormHttpMessageConverter)converter).setPartConverters(partConverters);
        }
        return restTemplate;
    }

    protected static class ContentResource
    extends AbstractResource {
        private Content content;
        private String filename;

        public ContentResource(Content content, String filename) {
            this.content = content;
            this.filename = filename;
        }

        public String getDescription() {
            return this.content.toString();
        }

        public String getFilename() {
            return this.filename;
        }

        public boolean exists() {
            return true;
        }

        public long contentLength() throws IOException {
            return this.content.getLength();
        }

        public long lastModified() throws IOException {
            return this.content.getLastModified();
        }

        public InputStream getInputStream() throws IOException {
            return this.content.getInputStream();
        }
    }
}

