/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.util.url.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.craftercms.core.util.url.ContentBundleUrl;
import org.craftercms.core.util.url.ContentBundleUrlParser;
import org.craftercms.core.util.url.impl.ContentBundleUrlImpl;

public class RegexBasedContentBundleUrlParser
implements ContentBundleUrlParser {
    private int prefixGroup;
    private int baseNameAndExtensionTokenGroup;
    private int suffixGroup;
    private Pattern pattern;

    public RegexBasedContentBundleUrlParser(int prefixGroup, int baseNameAndExtensionTokenGroup, int suffixGroup, Pattern pattern) {
        this.prefixGroup = prefixGroup;
        this.baseNameAndExtensionTokenGroup = baseNameAndExtensionTokenGroup;
        this.suffixGroup = suffixGroup;
        this.pattern = pattern;
    }

    @Override
    public ContentBundleUrl getContentBundleUrl(String rawUrl) {
        ContentBundleUrlImpl parsedUrl = new ContentBundleUrlImpl();
        Matcher matcher = this.pattern.matcher(rawUrl);
        if (matcher.matches()) {
            try {
                parsedUrl.setPrefix(matcher.group(this.prefixGroup));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                parsedUrl.setBaseNameAndExtensionToken(matcher.group(this.baseNameAndExtensionTokenGroup));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                parsedUrl.setSuffix(matcher.group(this.suffixGroup));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return parsedUrl;
    }
}

