/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.util.template.impl.spel;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.craftercms.core.exception.TemplateException;
import org.craftercms.core.util.template.CompiledTemplate;
import org.craftercms.core.util.template.TemplateCompiler;
import org.craftercms.core.util.template.impl.IdentifiableStringTemplateSource;
import org.craftercms.core.util.template.impl.spel.SpElCompiledTemplate;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.expression.spel.support.StandardTypeLocator;

public class SpELStringTemplateCompiler
implements TemplateCompiler<IdentifiableStringTemplateSource>,
BeanFactoryAware,
InitializingBean {
    private ExpressionParser parser = new SpelExpressionParser();
    private ParserContext parserContext = new TemplateParserContext();
    private EvaluationContext evalContext;
    private ConfigurableBeanFactory beanFactory;
    private Map<String, Expression> expressionCache = new ConcurrentHashMap<String, Expression>();

    public void setParserContext(ParserContext parserContext) {
        this.parserContext = parserContext;
    }

    public void setEvalContext(EvaluationContext evalContext) {
        this.evalContext = evalContext;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ConfigurableBeanFactory)) {
            throw new IllegalArgumentException("beanFactory should be of type ConfigurableBeanFactory");
        }
        this.beanFactory = (ConfigurableBeanFactory)beanFactory;
    }

    public void afterPropertiesSet() {
        if (this.evalContext == null) {
            this.evalContext = new StandardEvaluationContext();
        }
        if (this.evalContext instanceof StandardEvaluationContext) {
            StandardEvaluationContext standardEvalContext = (StandardEvaluationContext)this.evalContext;
            standardEvalContext.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
            if (this.beanFactory != null) {
                ConversionService conversionService;
                if (standardEvalContext.getBeanResolver() == null) {
                    standardEvalContext.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)this.beanFactory));
                }
                if (standardEvalContext.getTypeLocator() == null) {
                    standardEvalContext.setTypeLocator((TypeLocator)new StandardTypeLocator(this.beanFactory.getBeanClassLoader()));
                }
                if (standardEvalContext.getTypeConverter() == null && (conversionService = this.beanFactory.getConversionService()) != null) {
                    standardEvalContext.setTypeConverter((TypeConverter)new StandardTypeConverter(conversionService));
                }
            }
        }
    }

    @Override
    public CompiledTemplate compile(IdentifiableStringTemplateSource templateSource) throws TemplateException {
        String id = templateSource.getId();
        String source = templateSource.getSource();
        try {
            Expression expression = this.expressionCache.get(id);
            if (expression == null || !expression.getExpressionString().equals(source)) {
                expression = this.parser.parseExpression(source, this.parserContext);
                this.expressionCache.put(id, expression);
            }
            return new SpElCompiledTemplate(expression, this.evalContext);
        }
        catch (Exception e) {
            throw new TemplateException("Unable to compile SpEL template:\n" + source, e);
        }
    }
}

