/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.util.template.impl.freemarker;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import org.craftercms.core.exception.TemplateException;
import org.craftercms.core.util.template.CompiledTemplate;
import org.craftercms.core.util.template.TemplateCompiler;
import org.craftercms.core.util.template.impl.IdentifiableStringTemplateSource;
import org.craftercms.core.util.template.impl.freemarker.ConcurrentStringTemplateLoader;
import org.craftercms.core.util.template.impl.freemarker.FreeMarkerCompiledTemplate;

public class FreeMarkerStringTemplateCompiler
implements TemplateCompiler<IdentifiableStringTemplateSource> {
    private Configuration templateConfiguration;
    private ConcurrentStringTemplateLoader templateLoader = new ConcurrentStringTemplateLoader();

    public FreeMarkerStringTemplateCompiler() {
        this.templateConfiguration = new Configuration(Configuration.VERSION_2_3_23);
        this.templateConfiguration.setTemplateLoader((TemplateLoader)this.templateLoader);
        this.templateConfiguration.setTemplateUpdateDelayMilliseconds(0L);
    }

    public void setTemplateConfiguration(Configuration templateConfiguration) {
        this.templateConfiguration = templateConfiguration;
    }

    public void setTemplateLoader(ConcurrentStringTemplateLoader templateLoader) {
        this.templateLoader = templateLoader;
    }

    @Override
    public CompiledTemplate compile(IdentifiableStringTemplateSource templateSource) throws TemplateException {
        String id = templateSource.getId().replace('/', ';');
        String source = templateSource.getSource();
        ConcurrentStringTemplateLoader.StringTemplateSource currentTemplateSource = (ConcurrentStringTemplateLoader.StringTemplateSource)this.templateLoader.findTemplateSource(id);
        if (currentTemplateSource == null || !currentTemplateSource.getSource().equals(source)) {
            this.templateLoader.putTemplateSource(id, source);
        }
        try {
            return new FreeMarkerCompiledTemplate(this.templateConfiguration.getTemplate(id));
        }
        catch (Exception e) {
            throw new TemplateException("Unable to compile Freemarker template:\n" + source, e);
        }
    }
}

