/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.util.template.impl.freemarker;

import freemarker.cache.TemplateLoader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentStringTemplateLoader
implements TemplateLoader {
    private final Map<String, StringTemplateSource> templates = new ConcurrentHashMap<String, StringTemplateSource>();

    public boolean hasTemplateSource(String name) {
        return this.templates.containsKey(name);
    }

    public void putTemplateSource(String name, String templateSource) {
        this.putTemplateSource(name, templateSource, System.currentTimeMillis());
    }

    public void putTemplateSource(String name, String templateSource, long lastModified) {
        this.templates.put(name, new StringTemplateSource(name, templateSource, lastModified));
    }

    public void removeTemplateSource(String name) {
        this.templates.remove(name);
    }

    public void closeTemplateSource(Object templateSource) {
    }

    public Object findTemplateSource(String name) {
        return this.templates.get(name);
    }

    public long getLastModified(Object templateSource) {
        return ((StringTemplateSource)templateSource).lastModified;
    }

    public Reader getReader(Object templateSource, String encoding) {
        return new StringReader(((StringTemplateSource)templateSource).source);
    }

    public static class StringTemplateSource {
        private final String name;
        private final String source;
        private final long lastModified;

        public StringTemplateSource(String name, String source, long lastModified) {
            if (name == null) {
                throw new IllegalArgumentException("name == null");
            }
            if (source == null) {
                throw new IllegalArgumentException("source == null");
            }
            if (lastModified < -1L) {
                throw new IllegalArgumentException("lastModified < -1L");
            }
            this.name = name;
            this.source = source;
            this.lastModified = lastModified;
        }

        public String getName() {
            return this.name;
        }

        public String getSource() {
            return this.source;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public boolean equals(Object obj) {
            if (obj instanceof StringTemplateSource) {
                return this.name.equals(((StringTemplateSource)obj).name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

