/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class XmlUtils {
    public static Object selectObject(Node node, String xpathQuery) {
        Object result = node.selectObject(xpathQuery);
        if (result != null && result instanceof Collection && ((Collection)result).isEmpty()) {
            return null;
        }
        return result;
    }

    public static String selectSingleNodeValue(Node node, String xpathQuery) {
        Node resultNode = node.selectSingleNode(xpathQuery);
        if (resultNode != null) {
            return resultNode.getText();
        }
        return null;
    }

    public static String selectSingleNodeValue(Node node, String xpathQuery, Map<String, String> namespaceUris) {
        Node resultNode = XmlUtils.selectSingleNode(node, xpathQuery, namespaceUris);
        if (resultNode != null) {
            return resultNode.getText();
        }
        return null;
    }

    public static List<String> selectNodeValues(Node node, String xpathQuery) {
        List resultNodes = node.selectNodes(xpathQuery);
        return XmlUtils.extractNodeValues(resultNodes);
    }

    public static List<String> selectNodeValues(Node node, String xpathQuery, Map<String, String> namespaceUris) {
        List<Node> resultNodes = XmlUtils.selectNodes(node, xpathQuery, namespaceUris);
        return XmlUtils.extractNodeValues(resultNodes);
    }

    public static Node selectSingleNode(Node node, String xpathQuery, Map<String, String> namespaceUris) {
        XPath xpath = DocumentHelper.createXPath((String)xpathQuery);
        xpath.setNamespaceURIs(namespaceUris);
        return xpath.selectSingleNode((Object)node);
    }

    public static List<Node> selectNodes(Node node, String xpathQuery, Map<String, String> namespaceUris) {
        XPath xpath = DocumentHelper.createXPath((String)xpathQuery);
        xpath.setNamespaceURIs(namespaceUris);
        return xpath.selectNodes((Object)node);
    }

    public static String documentToPrettyString(Document document) {
        StringWriter stringWriter = new StringWriter();
        OutputFormat prettyPrintFormat = OutputFormat.createPrettyPrint();
        XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, prettyPrintFormat);
        try {
            xmlWriter.write(document);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    private static List<String> extractNodeValues(List<Node> nodes) {
        if (CollectionUtils.isNotEmpty(nodes)) {
            ArrayList<String> nodeValues = new ArrayList<String>(nodes.size());
            for (Node resultNode : nodes) {
                nodeValues.add(resultNode.getText());
            }
            return nodeValues;
        }
        return Collections.emptyList();
    }
}

