/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.url.impl;

import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.exception.UrlTransformationException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.url.UrlTransformer;
import org.craftercms.core.util.UrlUtils;

public class ShortToLongUrlTransformer
implements UrlTransformer {
    private static final Log logger = LogFactory.getLog(ShortToLongUrlTransformer.class);
    private String containsShortNameRegex = "\\b\\d*_(.+)\\b";
    private int shortNameRegexGroup = 1;

    public void setContainsShortNameRegex(String containsShortNameRegex) {
        this.containsShortNameRegex = containsShortNameRegex;
    }

    public void setShortNameRegexGroup(int shortNameRegexGroup) {
        this.shortNameRegexGroup = shortNameRegexGroup;
    }

    @Override
    public String transformUrl(Context context, CachingOptions cachingOptions, String url) throws UrlTransformationException {
        String result = this.getLongUrl(context, cachingOptions, url, true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Transformation in: " + url + ", Transformation out: " + result));
        }
        return result;
    }

    protected String getLongName(Context context, CachingOptions cachingOptions, String folderPath, String shortName) throws UrlTransformationException {
        try {
            List<Item> items = context.getStoreAdapter().findItems(context, cachingOptions, folderPath);
            if (CollectionUtils.isNotEmpty(items)) {
                for (Item item : items) {
                    String itemName = item.getName();
                    if (!UrlUtils.getShortName(itemName, this.containsShortNameRegex, this.shortNameRegexGroup).equalsIgnoreCase(shortName)) continue;
                    return itemName;
                }
            }
        }
        catch (Exception e) {
            throw new UrlTransformationException("An error occurred while retrieving the items at " + folderPath + " and trying to map the short name '" + shortName + "' to an item's name (long name)", e);
        }
        return null;
    }

    protected String getLongUrl(Context context, CachingOptions cachingOptions, String shortUrl, boolean useShortNameIfLongNameNotFound) throws UrlTransformationException {
        Object[] levels = StringUtils.strip((String)shortUrl, (String)"/").split("/");
        StringBuilder result = new StringBuilder();
        if (ArrayUtils.isNotEmpty((Object[])levels)) {
            for (Object level : levels) {
                String folderPath = result.toString();
                folderPath = StringUtils.isNotEmpty((CharSequence)folderPath) ? folderPath : "/";
                String longName = this.getLongName(context, cachingOptions, folderPath, (String)level);
                if (StringUtils.isNotEmpty((CharSequence)longName)) {
                    result.append("/").append(longName);
                    continue;
                }
                if (useShortNameIfLongNameNotFound) {
                    result.append("/").append((String)level);
                    continue;
                }
                return null;
            }
        }
        if (shortUrl.endsWith("/")) {
            result.append("/");
        }
        return result.toString();
    }
}

