/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.url.impl;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.url.UrlTransformer;
import org.craftercms.core.util.UrlUtils;

public class LongToShortUrlTransformer
implements UrlTransformer {
    private static final Log logger = LogFactory.getLog(LongToShortUrlTransformer.class);
    public static final String URL_NUMBERED_NAME_REGEX = "\\b\\d*_(.+)\\b";
    public static final int URL_NUMBERED_NAME_REGEX_SHORT_NAME_GROUP = 1;
    private String containsShortNameRegex = "\\b\\d*_(.+)\\b";
    private int shortNameRegexGroup = 1;

    public void setContainsShortNameRegex(String containsShortNameRegex) {
        this.containsShortNameRegex = containsShortNameRegex;
    }

    public void setShortNameRegexGroup(int shortNameRegexGroup) {
        this.shortNameRegexGroup = shortNameRegexGroup;
    }

    protected String getShortUrl(String longUrl) {
        Object[] levels = StringUtils.strip((String)longUrl, (String)"/").split("/");
        StringBuilder result = new StringBuilder();
        if (ArrayUtils.isNotEmpty((Object[])levels)) {
            for (Object level : levels) {
                result.append("/").append(UrlUtils.getShortName((String)level, this.containsShortNameRegex, this.shortNameRegexGroup));
            }
        }
        if (longUrl.endsWith("/")) {
            result.append("/");
        }
        return result.toString();
    }

    @Override
    public String transformUrl(Context context, CachingOptions cachingOptions, String url) {
        String result = this.getShortUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Transformation in: " + url + ", Transformation out: " + result));
        }
        return result;
    }
}

