/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.url.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.exception.UrlTransformationException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.url.impl.ShortToLongUrlTransformer;
import org.craftercms.core.util.url.ContentBundleUrl;
import org.craftercms.core.util.url.ContentBundleUrlParser;

public class ContentBundleShortToLongUrlTransformer
extends ShortToLongUrlTransformer {
    private static final Log logger = LogFactory.getLog(ContentBundleShortToLongUrlTransformer.class);
    private ContentBundleUrlParser urlParser;
    private String baseDelimiter;

    public ContentBundleShortToLongUrlTransformer(ContentBundleUrlParser urlParser, String baseDelimiter) {
        this.urlParser = urlParser;
        this.baseDelimiter = baseDelimiter;
    }

    @Override
    public String transformUrl(Context context, CachingOptions cachingOptions, String url) throws UrlTransformationException {
        String result = this.getLongUrlLookingInBundle(context, cachingOptions, url);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Transformation in: " + url + ", Transformation out: " + result));
        }
        return result;
    }

    private String getLongUrlLookingInBundle(Context context, CachingOptions cachingOptions, String shortUrl) throws UrlTransformationException {
        int delimiterIdx;
        ContentBundleUrl parsedUrl = this.urlParser.getContentBundleUrl(shortUrl);
        String prefix = parsedUrl.getPrefix();
        String originalBase = parsedUrl.getBaseNameAndExtensionToken();
        String suffix = parsedUrl.getSuffix();
        if (originalBase == null) {
            originalBase = "";
        }
        if (suffix == null) {
            suffix = "";
        }
        String base = originalBase;
        do {
            String currentShortUrl;
            String longUrl;
            if (StringUtils.isNotEmpty((CharSequence)(longUrl = this.getLongUrl(context, cachingOptions, currentShortUrl = prefix + base + suffix, false)))) {
                if (!originalBase.equals(base)) {
                    longUrl = longUrl.replace(base, originalBase);
                }
                return longUrl;
            }
            delimiterIdx = base.lastIndexOf(this.baseDelimiter);
            if (delimiterIdx <= 0) continue;
            base = base.substring(0, delimiterIdx);
        } while (delimiterIdx >= 0);
        throw new UrlTransformationException("Unable to map the short url '" + shortUrl + "' to a long url");
    }
}

