/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.url.impl;

import org.craftercms.commons.lang.Callback;
import org.craftercms.core.exception.UrlTransformationException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.url.UrlTransformationEngine;
import org.craftercms.core.util.cache.CacheTemplate;

public abstract class AbstractCachedUrlTransformationEngine
implements UrlTransformationEngine {
    public static final String TRANSFORMED_URL_CONST_KEY_ELEM = "urlTransformationEngine.transformedUrl";
    protected CacheTemplate cacheTemplate;

    public AbstractCachedUrlTransformationEngine(CacheTemplate cacheTemplate) {
        this.cacheTemplate = cacheTemplate;
    }

    @Override
    public String transformUrl(Context context, String transformerName, String url) throws UrlTransformationException {
        return this.transformUrl(context, CachingOptions.DEFAULT_CACHING_OPTIONS, transformerName, url);
    }

    @Override
    public String transformUrl(final Context context, final CachingOptions cachingOptions, final String transformerName, final String url) throws UrlTransformationException {
        return this.cacheTemplate.getObject(context, cachingOptions, new Callback<String>(){

            public String execute() {
                return AbstractCachedUrlTransformationEngine.this.doTransformUrl(context, cachingOptions, transformerName, url);
            }

            public String toString() {
                return String.format(AbstractCachedUrlTransformationEngine.this.getClass().getName() + ".transformUrl(%s, %s, %s)", context, transformerName, url);
            }
        }, transformerName, url, TRANSFORMED_URL_CONST_KEY_ELEM);
    }

    protected abstract String doTransformUrl(Context var1, CachingOptions var2, String var3, String var4) throws UrlTransformationException;
}

