/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.service.impl;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.craftercms.commons.lang.RegexUtils;
import org.craftercms.core.service.Item;
import org.craftercms.core.service.ItemFilter;

public class IncludeByUrlItemFilter
implements ItemFilter {
    private String[] includeRegexes;

    public IncludeByUrlItemFilter(String[] includeRegexes) {
        this.includeRegexes = includeRegexes;
    }

    @Override
    public boolean runBeforeProcessing() {
        return true;
    }

    @Override
    public boolean runAfterProcessing() {
        return false;
    }

    @Override
    public boolean accepts(Item item, List<Item> acceptedItems, List<Item> rejectedItems, boolean runningBeforeProcessing) {
        return ArrayUtils.isEmpty((Object[])this.includeRegexes) || RegexUtils.matchesAny((String)item.getUrl(), (String[])this.includeRegexes);
    }

    public String toString() {
        return "IncludeByUrlItemFilter{includeRegexes=" + Arrays.toString(this.includeRegexes) + "}";
    }
}

