/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.service.impl;

import java.util.Collection;
import java.util.Collections;
import org.craftercms.core.cache.Cache;
import org.craftercms.core.cache.CacheItem;
import org.craftercms.core.cache.CacheLoader;
import org.craftercms.core.cache.CacheStatistics;
import org.craftercms.core.exception.InternalCacheEngineException;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.InvalidScopeException;
import org.craftercms.core.service.CacheService;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;

public class CacheServiceImpl
implements CacheService {
    protected Cache cache;

    public CacheServiceImpl(Cache cache) {
        this.cache = cache;
    }

    @Override
    public Collection<String> getScopes() throws InternalCacheEngineException {
        return this.cache.getScopes();
    }

    @Override
    public void clearAll() throws InternalCacheEngineException {
        this.cache.clearAll();
    }

    @Override
    public void addScope(Context context) throws InternalCacheEngineException {
        if (context.isCacheOn()) {
            this.cache.addScope(context.getCacheScope(), context.getMaxAllowedItemsInCache());
        }
    }

    @Override
    public void removeScope(Context context) throws InvalidContextException, InternalCacheEngineException {
        if (context.isCacheOn()) {
            try {
                this.cache.removeScope(context.getCacheScope());
            }
            catch (InvalidScopeException e) {
                throw new InvalidContextException("No scope associated to context " + String.valueOf(context));
            }
        }
    }

    @Override
    public boolean hasScope(Context context) throws InvalidContextException, InternalCacheEngineException {
        if (context.isCacheOn()) {
            try {
                return this.cache.hasScope(context.getCacheScope());
            }
            catch (InvalidScopeException e) {
                throw new InvalidContextException("No scope associated to context " + String.valueOf(context));
            }
        }
        return false;
    }

    @Override
    public int getSize(Context context) throws InvalidContextException, InternalCacheEngineException {
        if (context.isCacheOn()) {
            try {
                return this.cache.getSize(context.getCacheScope());
            }
            catch (InvalidScopeException e) {
                throw new InvalidContextException("No scope associated to context " + String.valueOf(context));
            }
        }
        return 0;
    }

    @Override
    public Collection<?> getKeys(Context context) throws InvalidContextException, InternalCacheEngineException {
        if (context.isCacheOn()) {
            try {
                return this.cache.getKeys(context.getCacheScope());
            }
            catch (InvalidScopeException e) {
                throw new InvalidContextException("No scope associated to context " + String.valueOf(context));
            }
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasKey(Context context, Object key) throws InvalidContextException, InternalCacheEngineException {
        if (context.isCacheOn()) {
            try {
                return this.cache.hasKey(context.getCacheScope(), key);
            }
            catch (InvalidScopeException e) {
                throw new InvalidContextException("No scope associated to context " + String.valueOf(context));
            }
        }
        return false;
    }

    @Override
    public CacheItem getItem(Context context, Object key) throws InvalidContextException, InternalCacheEngineException {
        if (context.isCacheOn()) {
            try {
                return this.cache.get(context.getCacheScope(), key);
            }
            catch (InvalidScopeException e) {
                throw new InvalidContextException("No scope associated to context " + String.valueOf(context));
            }
        }
        return null;
    }

    @Override
    public Object get(Context context, Object key) throws InvalidContextException, InternalCacheEngineException {
        if (context.isCacheOn()) {
            try {
                CacheItem item = this.cache.get(context.getCacheScope(), key);
                if (item != null) {
                    return item.getValue();
                }
                return null;
            }
            catch (InvalidScopeException e) {
                throw new InvalidContextException("No scope associated to context " + String.valueOf(context));
            }
        }
        return null;
    }

    @Override
    public void put(Context context, Object key, Object value) throws InvalidContextException, InternalCacheEngineException {
        if (context.isCacheOn()) {
            try {
                this.cache.put(context.getCacheScope(), key, value);
            }
            catch (InvalidScopeException e) {
                throw new InvalidContextException("No scope associated to context " + String.valueOf(context));
            }
        }
    }

    @Override
    public void put(Context context, Object key, Object value, CachingOptions cachingOptions, CacheLoader loader, Object ... loaderParams) throws InvalidContextException, InternalCacheEngineException {
        if (context.isCacheOn() && cachingOptions.doCaching()) {
            try {
                this.cache.put(context.getCacheScope(), key, value, cachingOptions.getExpireAfter(), cachingOptions.getRefreshFrequency(), loader, loaderParams);
            }
            catch (InvalidScopeException e) {
                throw new InvalidContextException("No scope associated to context " + String.valueOf(context));
            }
        }
    }

    @Override
    public boolean remove(Context context, Object key) throws InvalidContextException, InternalCacheEngineException {
        if (context.isCacheOn()) {
            try {
                return this.cache.remove(context.getCacheScope(), key);
            }
            catch (InvalidScopeException e) {
                throw new InvalidContextException("No scope associated to context " + String.valueOf(context));
            }
        }
        return false;
    }

    @Override
    public void clearScope(Context context) throws InvalidContextException, InternalCacheEngineException {
        if (context.isCacheOn()) {
            try {
                this.cache.clearScope(context.getCacheScope());
            }
            catch (InvalidScopeException e) {
                throw new InvalidContextException("No scope associated to context " + String.valueOf(context));
            }
        }
    }

    @Override
    public CacheStatistics getStatistics(Context context) {
        if (context.isCacheOn()) {
            return this.cache.getStatistics(context.getCacheScope());
        }
        return CacheStatistics.EMPTY;
    }
}

