/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.service;

import java.util.Map;
import org.craftercms.core.service.Context;
import org.craftercms.core.store.ContentStoreAdapter;

public class ContextImpl
implements Context {
    protected static final String CACHE_SCOPE_FORMAT = "%s-v%s";
    protected String id;
    protected ContentStoreAdapter storeAdapter;
    protected String rootFolderPath;
    protected boolean mergingOn;
    protected boolean cacheOn;
    protected volatile long cacheVersion;
    protected int maxAllowedItemsInCache;
    protected boolean ignoreHiddenFiles;
    protected Map<String, String> configurationVariables;

    public ContextImpl(String id, ContentStoreAdapter storeAdapter, String rootFolderPath, boolean mergingOn, boolean cacheOn, int maxAllowedItemsInCache, boolean ignoreHiddenFiles, Map<String, String> configurationVariables) {
        this.id = id;
        this.storeAdapter = storeAdapter;
        this.rootFolderPath = rootFolderPath;
        this.mergingOn = mergingOn;
        this.cacheOn = cacheOn;
        this.cacheVersion = System.nanoTime();
        this.maxAllowedItemsInCache = maxAllowedItemsInCache;
        this.ignoreHiddenFiles = ignoreHiddenFiles;
        this.configurationVariables = configurationVariables;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getCacheVersion() {
        return this.cacheVersion;
    }

    @Override
    public void setCacheVersion(long cacheVersion) {
        this.cacheVersion = cacheVersion;
    }

    @Override
    public String getCacheScope() {
        return String.format(CACHE_SCOPE_FORMAT, this.id, this.cacheVersion);
    }

    @Override
    public ContentStoreAdapter getStoreAdapter() {
        return this.storeAdapter;
    }

    @Override
    public boolean isMergingOn() {
        return this.mergingOn;
    }

    @Override
    public boolean isCacheOn() {
        return this.cacheOn;
    }

    @Override
    public int getMaxAllowedItemsInCache() {
        return this.maxAllowedItemsInCache;
    }

    @Override
    public boolean ignoreHiddenFiles() {
        return this.ignoreHiddenFiles;
    }

    @Override
    public Map<String, String> getConfigLookupVariables() {
        return this.configurationVariables;
    }

    @Override
    public Context clone() {
        try {
            return (Context)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Context context = (Context)o;
        return this.getId().equals(context.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{id='" + this.id + "', rootFolderPath='" + this.rootFolderPath + "'}";
    }
}

