/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.processors.impl.resolvers;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.core.exception.XmlException;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.processors.ItemProcessorResolver;
import org.craftercms.core.service.Item;

public class MetaDataProcessorResolver
implements ItemProcessorResolver {
    protected String processorElementXPathQuery;
    protected Map<String, ItemProcessor> elementValueToProcessorMappings;

    public MetaDataProcessorResolver(String processorElementXPathQuery, Map<String, ItemProcessor> elementValueToProcessorMappings) {
        this.processorElementXPathQuery = processorElementXPathQuery;
        this.elementValueToProcessorMappings = elementValueToProcessorMappings;
    }

    @Override
    public ItemProcessor getProcessor(Item item) throws XmlException {
        String processorElementValue = item.queryDescriptorValue(this.processorElementXPathQuery);
        if (StringUtils.isNotEmpty((CharSequence)processorElementValue)) {
            ItemProcessor processor = this.elementValueToProcessorMappings.get(processorElementValue);
            if (processor != null) {
                return processor;
            }
            throw new XmlException("Element value \"" + processorElementValue + "\" doesn't refer to a registered processor");
        }
        return null;
    }
}

