/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.processors.impl.resolvers;

import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.processors.ItemProcessorResolver;
import org.craftercms.core.service.Item;

public class ItemProcessorResolverChain
implements ItemProcessorResolver {
    protected ItemProcessor defaultProcessor;
    protected List<ItemProcessorResolver> resolvers;

    public ItemProcessorResolverChain(ItemProcessor defaultProcessor, List<ItemProcessorResolver> resolvers) {
        this.defaultProcessor = defaultProcessor;
        this.resolvers = resolvers;
    }

    @Override
    public ItemProcessor getProcessor(Item item) {
        if (CollectionUtils.isNotEmpty(this.resolvers)) {
            for (ItemProcessorResolver resolver : this.resolvers) {
                ItemProcessor processor = resolver.getProcessor(item);
                if (processor == null) continue;
                return processor;
            }
        }
        return this.defaultProcessor;
    }
}

