/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.processors.impl;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.core.processors.impl.AbstractTaggingProcessor;
import org.craftercms.core.service.Item;
import org.craftercms.core.util.XmlUtils;
import org.dom4j.Document;
import org.dom4j.Node;

public class TaggingByFieldValueProcessor
extends AbstractTaggingProcessor {
    protected String sourceField;
    protected Map<String, String> valueMapping;

    public TaggingByFieldValueProcessor(String sourceField, String defaultValue, Map<String, String> valueMapping, String newField) {
        super(newField);
        this.sourceField = sourceField;
        this.defaultValue = defaultValue;
        this.valueMapping = valueMapping;
    }

    @Override
    protected String getTagValues(Item item) {
        String sourceValue;
        String value = this.defaultValue;
        Document document = item.getDescriptorDom();
        if (document != null && StringUtils.isNotEmpty((CharSequence)(sourceValue = XmlUtils.selectSingleNodeValue((Node)document.getRootElement(), this.sourceField)))) {
            for (Map.Entry<String, String> entry : this.valueMapping.entrySet()) {
                if (!sourceValue.matches(entry.getKey())) continue;
                value = entry.getValue();
                break;
            }
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaggingByFieldValueProcessor that = (TaggingByFieldValueProcessor)o;
        if (this.sourceField != null ? !this.sourceField.equals(that.sourceField) : that.sourceField != null) {
            return false;
        }
        if (this.newField != null ? !this.newField.equals(that.newField) : that.newField != null) {
            return false;
        }
        if (this.defaultValue != null ? !this.defaultValue.equals(that.defaultValue) : that.defaultValue != null) {
            return false;
        }
        return this.valueMapping != null ? this.valueMapping.equals(that.valueMapping) : that.valueMapping == null;
    }

    public int hashCode() {
        int result = this.sourceField != null ? this.sourceField.hashCode() : 0;
        result = 31 * result + (this.newField != null ? this.newField.hashCode() : 0);
        result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
        result = 31 * result + (this.valueMapping != null ? this.valueMapping.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TaggingByFieldValueProcessor{sourceField='" + this.sourceField + "', newField='" + this.newField + "', defaultValue='" + this.defaultValue + "', valueMapping=" + String.valueOf(this.valueMapping) + "}";
    }
}

