/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.processors.impl;

import org.craftercms.core.exception.ItemProcessingException;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.url.UrlTransformationEngine;

public class ItemUrlTransformingProcessor
implements ItemProcessor {
    protected String transformedUrlPropName;
    protected String transformerName;
    protected UrlTransformationEngine urlTransformationEngine;

    public ItemUrlTransformingProcessor(String transformedUrlPropName, String transformerName, UrlTransformationEngine urlTransformationEngine) {
        this.transformedUrlPropName = transformedUrlPropName;
        this.transformerName = transformerName;
        this.urlTransformationEngine = urlTransformationEngine;
    }

    @Override
    public Item process(Context context, CachingOptions cachingOptions, Item item) throws ItemProcessingException {
        String transformedUrl = this.urlTransformationEngine.transformUrl(context, this.transformerName, item.getUrl());
        item.setProperty(this.transformedUrlPropName, transformedUrl);
        return item;
    }

    public String toString() {
        return "ItemUrlTransformingProcessor[transformedUrlPropName='" + this.transformedUrlPropName + "', transformerName='" + this.transformerName + "', urlTransformationEngine=" + String.valueOf(this.urlTransformationEngine) + "]";
    }
}

