/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.processors.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.exception.ItemProcessingException;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class FieldRenamingProcessor
implements ItemProcessor {
    private static final Log logger = LogFactory.getLog(FieldRenamingProcessor.class);
    private Map<String, String> fieldMappings;

    public void setFieldMappings(Map<String, String> fieldMappings) {
        this.fieldMappings = fieldMappings;
    }

    @Override
    public Item process(Context context, CachingOptions cachingOptions, Item item) throws ItemProcessingException {
        Document document = item.getDescriptorDom();
        if (document != null && MapUtils.isNotEmpty(this.fieldMappings)) {
            for (Map.Entry<String, String> entry : this.fieldMappings.entrySet()) {
                List nodes;
                String xpath = entry.getKey();
                String newName = entry.getValue();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Renaming elements that match XPath " + xpath + " to '" + newName + "' for descriptor of " + String.valueOf(item)));
                }
                if (!CollectionUtils.isNotEmpty((Collection)(nodes = document.selectNodes(xpath)))) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Number of matching nodes: " + nodes.size()));
                }
                for (Node node : nodes) {
                    if (node.getNodeType() == 1) {
                        Element element = (Element)node;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Renaming element " + element.getUniquePath() + " to "));
                        }
                        element.setName(newName);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Element renamed to " + element.getUniquePath()));
                        continue;
                    }
                    logger.info((Object)("Unable to execute against a non-XML-element: " + node.getUniquePath()));
                }
            }
        }
        return item;
    }
}

