/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.controller.rest;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.ConstraintViolationException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.craftercms.commons.exceptions.InvalidManagementTokenException;
import org.craftercms.commons.validation.ValidationException;
import org.craftercms.commons.validation.ValidationResult;
import org.craftercms.commons.validation.ValidationRuntimeException;
import org.craftercms.core.controller.rest.CrafterRestController;
import org.craftercms.core.controller.rest.RestControllerBase;
import org.craftercms.core.controller.rest.ValidationFieldError;
import org.craftercms.core.exception.AuthenticationException;
import org.craftercms.core.exception.ForbiddenPathException;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.PathNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@Order
@ControllerAdvice(annotations={CrafterRestController.class})
public class ExceptionHandlers {
    public static final String RESULT_KEY_VALIDATION_ERRORS = "validationErrors";
    private static final Logger logger = LoggerFactory.getLogger(ExceptionHandlers.class);

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public Map<String, Object> handleInvalidContextException(HttpServletRequest request, MissingServletRequestParameterException e) {
        return this.handleException(request, (Exception)e);
    }

    @ExceptionHandler(value={InvalidManagementTokenException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public Map<String, Object> handleInvalidContextException(HttpServletRequest request, InvalidManagementTokenException e) {
        return this.handleException(request, (Exception)e);
    }

    @ExceptionHandler(value={InvalidContextException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public Map<String, Object> handleInvalidContextException(HttpServletRequest request, InvalidContextException e) {
        return this.handleException(request, e);
    }

    @ExceptionHandler(value={AuthenticationException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public Map<String, Object> handleAuthenticationException(HttpServletRequest request, AuthenticationException e) {
        return this.handleException(request, e);
    }

    @ExceptionHandler(value={PathNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public Map<String, Object> handlePathNotFoundException(HttpServletRequest request, PathNotFoundException e) {
        return this.handleException(request, e);
    }

    @ExceptionHandler(value={ForbiddenPathException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public Map<String, Object> handleForbiddenPathException(HttpServletRequest request, ForbiddenPathException e) {
        return this.handleException(request, e);
    }

    @ExceptionHandler(value={ValidationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ValidationResult handleValidationException(HttpServletRequest request, ValidationException e) {
        logger.error("Request for " + request.getRequestURI() + " failed", (Throwable)e);
        return e.getResult();
    }

    @ExceptionHandler(value={ValidationRuntimeException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ValidationResult handleValidationRuntimeException(HttpServletRequest request, ValidationRuntimeException e) {
        logger.error("Request for " + request.getRequestURI() + " failed", (Throwable)e);
        return e.getResult();
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={ConstraintViolationException.class})
    public Map<String, Object> handleConstraintValidationException(ConstraintViolationException e) {
        List validationErrors = e.getConstraintViolations().stream().map(c -> new ValidationFieldError(c.getPropertyPath().toString(), c.getMessage())).collect(Collectors.toList());
        return Map.of(RESULT_KEY_VALIDATION_ERRORS, validationErrors);
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public Map<String, Object> handleMethodArgumentTypeMismatchException(MethodArgumentTypeMismatchException e) {
        List<ValidationFieldError> validationErrors = List.of(new ValidationFieldError(e.getName(), e.getMessage()));
        return Map.of(RESULT_KEY_VALIDATION_ERRORS, validationErrors);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public Map<String, Object> handleException(HttpServletRequest request, Exception e) {
        logger.error("Request for " + request.getRequestURI() + " failed", (Throwable)e);
        return RestControllerBase.createResponseMessage(e.getMessage());
    }
}

