/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.controller.rest;

import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.craftercms.commons.lang.RegexUtils;
import org.craftercms.core.controller.rest.RestControllerBase;
import org.craftercms.core.exception.ForbiddenPathException;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.ItemProcessingException;
import org.craftercms.core.exception.PathNotFoundException;
import org.craftercms.core.exception.StoreException;
import org.craftercms.core.exception.XmlFileParseException;
import org.craftercms.core.exception.XmlMergeException;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.service.ItemFilter;
import org.craftercms.core.service.Tree;
import org.craftercms.core.service.impl.CompositeItemFilter;
import org.craftercms.core.service.impl.ExcludeByUrlItemFilter;
import org.craftercms.core.service.impl.IncludeByUrlItemFilter;
import org.craftercms.core.util.cache.impl.CachingAwareList;
import org.dom4j.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;

@RestController
@RequestMapping(value={"${crafter.core.rest.base.uri}/content_store"})
public class ContentStoreRestController
extends RestControllerBase
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(ContentStoreRestController.class);
    public static final String URL_ROOT = "/content_store";
    public static final String CACHE_CONTROL_HEADER_NAME = "Cache-Control";
    public static final String MUST_REVALIDATE_HEADER_VALUE = "must-revalidate";
    public static final String REQUEST_PARAM_CONTEXT_ID = "contextId";
    public static final String REQUEST_PARAM_URL = "url";
    public static final String REQUEST_PARAM_TREE_DEPTH = "depth";
    public static final String URL_DESCRIPTOR = "/descriptor";
    public static final String URL_ITEM = "/item";
    public static final String URL_CHILDREN = "/children";
    public static final String URL_TREE = "/tree";
    private ContentStoreService storeService;
    private final int treeDepthLimit;
    private String[] allowedUrlPatterns;
    private String[] forbiddenUrlPatterns;
    private ItemFilter itemFilter;

    @ConstructorProperties(value={"storeService", "treeDepthLimit"})
    public ContentStoreRestController(ContentStoreService storeService, int treeDepthLimit) {
        this.storeService = storeService;
        this.treeDepthLimit = treeDepthLimit < 0 || treeDepthLimit > 20 ? 20 : treeDepthLimit;
    }

    public void setAllowedUrlPatterns(String[] allowedUrlPatterns) {
        this.allowedUrlPatterns = allowedUrlPatterns;
    }

    public void setForbiddenUrlPatterns(String[] forbiddenUrlPatterns) {
        this.forbiddenUrlPatterns = forbiddenUrlPatterns;
    }

    public void afterPropertiesSet() {
        CompositeItemFilter compositeItemFilter = new CompositeItemFilter();
        compositeItemFilter.setFilters(Arrays.asList(new IncludeByUrlItemFilter(this.allowedUrlPatterns), new ExcludeByUrlItemFilter(this.forbiddenUrlPatterns)));
        this.itemFilter = compositeItemFilter;
    }

    @RequestMapping(value={"/descriptor"}, method={RequestMethod.GET})
    public Document getDescriptor(WebRequest request, HttpServletResponse response, @RequestParam(value="contextId") String contextId, @RequestParam(value="url") String url, @RequestParam(required=false, defaultValue="false") boolean flatten) throws InvalidContextException, StoreException, PathNotFoundException, ForbiddenPathException, ItemProcessingException, XmlMergeException, XmlFileParseException {
        Item item = this.getItem(request, response, contextId, url, flatten);
        if (item != null) {
            return item.getDescriptorDom();
        }
        return null;
    }

    @RequestMapping(value={"/item"}, method={RequestMethod.GET})
    public Item getItem(WebRequest request, HttpServletResponse response, @RequestParam(value="contextId") String contextId, @RequestParam(value="url") String url, @RequestParam(required=false, defaultValue="false") boolean flatten) throws InvalidContextException, StoreException, PathNotFoundException, ForbiddenPathException, ItemProcessingException, XmlMergeException, XmlFileParseException {
        this.checkIfUrlAllowed(url);
        Context context = this.storeService.getContext(contextId);
        if (context == null) {
            throw new InvalidContextException("No context found for ID " + contextId);
        }
        Item item = this.storeService.getItem(context, null, url, null, flatten);
        if (item.getCachingTime() != null && this.checkNotModified(item.getCachingTime(), request, response)) {
            return null;
        }
        return item;
    }

    @RequestMapping(value={"/children"}, method={RequestMethod.GET})
    public List<Item> getChildren(WebRequest request, HttpServletResponse response, @RequestParam(value="contextId") String contextId, @RequestParam(value="url") String url, @RequestParam(required=false, defaultValue="false") boolean flatten) throws InvalidContextException, StoreException, PathNotFoundException, ForbiddenPathException, ItemProcessingException, XmlMergeException, XmlFileParseException {
        this.checkIfUrlAllowed(url);
        Context context = this.storeService.getContext(contextId);
        if (context == null) {
            throw new InvalidContextException("No context found for ID " + contextId);
        }
        CachingAwareList children = (CachingAwareList)this.storeService.getChildren(context, null, url, this.itemFilter, null, flatten);
        if (children.getCachingTime() != null && this.checkNotModified(children.getCachingTime(), request, response)) {
            return null;
        }
        return new ArrayList<Item>(children);
    }

    @RequestMapping(value={"/tree"}, method={RequestMethod.GET})
    public Tree getTree(WebRequest request, HttpServletResponse response, @RequestParam(value="contextId") String contextId, @RequestParam(value="url") String url, @RequestParam(value="depth", required=false) Integer depth, @RequestParam(required=false, defaultValue="false") boolean flatten) throws InvalidContextException, StoreException, PathNotFoundException, ForbiddenPathException, ItemProcessingException, XmlMergeException, XmlFileParseException {
        this.checkIfUrlAllowed(url);
        Context context = this.storeService.getContext(contextId);
        if (context == null) {
            throw new IllegalArgumentException("No context found for ID " + contextId);
        }
        if (depth == null || depth < 0 || depth > this.treeDepthLimit) {
            depth = this.treeDepthLimit;
        }
        try {
            Tree tree = this.storeService.getTree(context, null, url, depth, this.itemFilter, null, false);
            if (tree.getCachingTime() != null && this.checkNotModified(tree.getCachingTime(), request, response)) {
                return null;
            }
            return tree;
        }
        catch (OutOfMemoryError error) {
            logger.error("Unable to fulfill the request. Out of memory exception occurred.", (Throwable)error);
            logger.info("Maximum JVM memory is '{}' bytes", (Object)Runtime.getRuntime().maxMemory());
            throw new StoreException("Unable to fulfill the request. Out of memory exception occurred.");
        }
    }

    private boolean checkNotModified(long lastModifiedTimestamp, WebRequest request, HttpServletResponse response) {
        response.setHeader(CACHE_CONTROL_HEADER_NAME, MUST_REVALIDATE_HEADER_VALUE);
        return request.checkNotModified(lastModifiedTimestamp);
    }

    private boolean isUrlAllowed(String url) {
        return !(!ArrayUtils.isEmpty((Object[])this.allowedUrlPatterns) && !RegexUtils.matchesAny((String)url, (String[])this.allowedUrlPatterns) || !ArrayUtils.isEmpty((Object[])this.forbiddenUrlPatterns) && RegexUtils.matchesAny((String)url, (String[])this.forbiddenUrlPatterns));
    }

    private void checkIfUrlAllowed(String url) throws ForbiddenPathException {
        if (!this.isUrlAllowed(url)) {
            throw new ForbiddenPathException("Access denied to URL " + url);
        }
    }
}

