/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.cache.impl.store;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.craftercms.core.cache.CacheItem;
import org.craftercms.core.cache.CacheStatistics;
import org.craftercms.core.cache.impl.CacheStoreAdapter;
import org.craftercms.core.exception.InvalidScopeException;

public class MapCacheStoreAdapter
implements CacheStoreAdapter {
    private Map<String, Map<Object, CacheItem>> scopeCaches = new ConcurrentHashMap<String, Map<Object, CacheItem>>();

    public MapCacheStoreAdapter() {
    }

    public MapCacheStoreAdapter(List<String> scopes) {
        this();
        for (String scope : scopes) {
            this.scopeCaches.put(scope, new ConcurrentHashMap());
        }
    }

    @Override
    public boolean hasScope(String scope) throws Exception {
        return this.scopeCaches.containsKey(scope);
    }

    @Override
    public Collection<String> getScopes() throws Exception {
        return this.scopeCaches.keySet();
    }

    @Override
    public void addScope(String scope, int maxItemsInMemory) throws Exception {
        this.scopeCaches.put(scope, new ConcurrentHashMap());
    }

    @Override
    public void removeScope(String scope) throws Exception {
        this.scopeCaches.remove(scope);
    }

    @Override
    public int getSize(String scope) throws Exception {
        return this.getScopeCache(scope).size();
    }

    @Override
    public Collection<Object> getKeys(String scope) throws Exception {
        return this.getScopeCache(scope).keySet();
    }

    @Override
    public boolean hasKey(String scope, Object key) throws Exception {
        return this.getScopeCache(scope).containsKey(key);
    }

    @Override
    public CacheItem get(String scope, Object key) throws Exception {
        return this.getScopeCache(scope).get(key);
    }

    @Override
    public void put(CacheItem item) throws Exception {
        this.getScopeCache(item.getScope()).put(item.getKey(), item);
    }

    @Override
    public boolean remove(String scope, Object key) throws Exception {
        return this.getScopeCache(scope).remove(key) != null;
    }

    @Override
    public void clearAll() throws Exception {
        this.scopeCaches.clear();
    }

    @Override
    public void clearScope(String scope) throws Exception {
        this.getScopeCache(scope).clear();
    }

    @Override
    public CacheStatistics getStatistics(String scope) {
        return new CacheStatistics(this.getScopeCache(scope).size());
    }

    private Map<Object, CacheItem> getScopeCache(String scope) throws InvalidScopeException {
        Map<Object, CacheItem> scopeCache = this.scopeCaches.get(scope);
        if (scopeCache == null) {
            throw new InvalidScopeException("The scope " + scope + " doesn't exist");
        }
        return scopeCache;
    }
}

