/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.util.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class Dom4jDocumentJsonSerializer
extends JsonSerializer<Document> {
    public static final String TEXT_JSON_KEY = "text";

    public void serialize(Document doc, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeFieldName(doc.getRootElement().getName());
        this.elementToJson(doc.getRootElement(), jsonGenerator);
        jsonGenerator.writeEndObject();
    }

    public Class<Document> handledType() {
        return Document.class;
    }

    private void elementToJson(Element element, JsonGenerator jsonGenerator) throws IOException {
        boolean objectStarted = false;
        if (element.attributeCount() > 0) {
            List attributes = element.attributes();
            jsonGenerator.writeStartObject();
            objectStarted = true;
            for (Attribute attribute : attributes) {
                jsonGenerator.writeStringField(attribute.getName(), attribute.getValue());
            }
        }
        if (!element.hasContent()) {
            if (!objectStarted) {
                jsonGenerator.writeNull();
            }
        } else if (element.isTextOnly()) {
            if (!objectStarted) {
                jsonGenerator.writeString(element.getText());
            } else {
                jsonGenerator.writeStringField(TEXT_JSON_KEY, element.getText());
            }
        } else {
            if (!objectStarted) {
                jsonGenerator.writeStartObject();
                objectStarted = true;
            }
            if (element.hasMixedContent()) {
                List<String> textContent = this.getTextContentFromMixedContent(element);
                if (textContent.size() > 1) {
                    jsonGenerator.writeArrayFieldStart(TEXT_JSON_KEY);
                    for (String string : textContent) {
                        jsonGenerator.writeString(string);
                    }
                    jsonGenerator.writeEndArray();
                } else if (textContent.size() == 1) {
                    jsonGenerator.writeStringField(TEXT_JSON_KEY, textContent.get(0));
                }
            }
            Map<String, List<Element>> children = this.getChildren(element);
            for (Map.Entry entry : children.entrySet()) {
                if (((List)entry.getValue()).size() > 1) {
                    jsonGenerator.writeArrayFieldStart((String)entry.getKey());
                    for (Element child : (List)entry.getValue()) {
                        this.elementToJson(child, jsonGenerator);
                    }
                    jsonGenerator.writeEndArray();
                    continue;
                }
                jsonGenerator.writeFieldName((String)entry.getKey());
                this.elementToJson((Element)((List)entry.getValue()).get(0), jsonGenerator);
            }
        }
        if (objectStarted) {
            jsonGenerator.writeEndObject();
        }
    }

    private List<String> getTextContentFromMixedContent(Element element) {
        List content = element.content();
        ArrayList<String> textContent = new ArrayList<String>();
        for (Node node : content) {
            String text;
            if (node.getNodeType() != 3 || !StringUtils.isNotBlank((CharSequence)(text = node.getText()))) continue;
            textContent.add(text);
        }
        return textContent;
    }

    private Map<String, List<Element>> getChildren(Element element) {
        LinkedHashMap<String, List<Element>> groupedChildren = new LinkedHashMap<String, List<Element>>();
        List children = element.elements();
        for (Element child : children) {
            if (groupedChildren.containsKey(child.getName())) {
                ((List)groupedChildren.get(child.getName())).add(child);
                continue;
            }
            ArrayList<Element> elements = new ArrayList<Element>();
            elements.add(child);
            groupedChildren.put(child.getName(), elements);
        }
        return groupedChildren;
    }
}

