/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.util.cache.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.craftercms.core.util.cache.CachingAwareObject;

public abstract class CachingAwareObjectBase
implements CachingAwareObject {
    protected transient String scope;
    protected transient Object key;
    protected transient List<Object> dependencyKeys;
    protected transient Long cachingTime;

    protected CachingAwareObjectBase() {
    }

    protected CachingAwareObjectBase(CachingAwareObject cachingAwareObject, boolean deepCopy) {
        this.scope = cachingAwareObject.getScope();
        this.key = cachingAwareObject.getKey();
        this.cachingTime = cachingAwareObject.getCachingTime();
        this.dependencyKeys = deepCopy ? (cachingAwareObject.getDependencyKeys() != null ? new ArrayList<Object>(cachingAwareObject.getDependencyKeys()) : null) : cachingAwareObject.getDependencyKeys();
    }

    @Override
    @JsonIgnore
    public String getScope() {
        return this.scope;
    }

    @Override
    @JsonIgnore
    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    @JsonIgnore
    public Object getKey() {
        return this.key;
    }

    @Override
    public void setKey(Object key) {
        this.key = key;
    }

    @Override
    @JsonIgnore
    public List<Object> getDependencyKeys() {
        return this.dependencyKeys;
    }

    @Override
    @JsonIgnore
    public void setDependencyKeys(List<Object> dependencyKeys) {
        this.dependencyKeys = dependencyKeys;
    }

    @Override
    public void addDependencyKeys(Collection<Object> dependencyKeys) {
        if (this.dependencyKeys == null) {
            this.dependencyKeys = new ArrayList<Object>();
        }
        this.dependencyKeys.addAll(dependencyKeys);
    }

    @Override
    public void addDependencyKey(Object dependencyKey) {
        if (this.dependencyKeys == null) {
            this.dependencyKeys = new ArrayList<Object>();
        }
        this.dependencyKeys.add(dependencyKey);
    }

    @Override
    public boolean removeDependencyKeys(Collection<Object> dependencyKeys) {
        if (this.dependencyKeys != null) {
            return this.dependencyKeys.removeAll(dependencyKeys);
        }
        return false;
    }

    @Override
    public boolean removeDependencyKey(Object dependencyKey) {
        if (this.dependencyKeys != null) {
            return this.dependencyKeys.remove(dependencyKey);
        }
        return false;
    }

    @Override
    @JsonIgnore
    public Long getCachingTime() {
        return this.cachingTime;
    }

    @Override
    @JsonIgnore
    public void setCachingTime(Long cachingTime) {
        this.cachingTime = cachingTime;
    }
}

