/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.url.impl;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.core.exception.UrlTransformationException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.url.UrlTransformer;

public class UrlTransformerPipeline
implements UrlTransformer {
    private List<UrlTransformer> transformers;

    public UrlTransformerPipeline() {
    }

    public UrlTransformerPipeline(List<UrlTransformer> transformers) {
        this.transformers = transformers;
    }

    public UrlTransformerPipeline(UrlTransformer ... transformers) {
        this.transformers = Arrays.asList(transformers);
    }

    @Override
    public String transformUrl(Context context, CachingOptions cachingOptions, String url) throws UrlTransformationException {
        if (CollectionUtils.isNotEmpty(this.transformers)) {
            for (UrlTransformer transformer : this.transformers) {
                url = transformer.transformUrl(context, cachingOptions, url);
            }
        }
        return url;
    }
}

