/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.url.impl;

import javax.servlet.http.HttpServletRequest;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.core.exception.UrlTransformationException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.url.UrlTransformer;

public class AddSchemeAndDomainAndServerPortUrlTransformer
implements UrlTransformer {
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final int DEFAULT_HTTPS_PORT = 443;
    protected boolean forceHttps = false;
    protected int httpsPort = 443;

    public void setForceHttps(boolean forceHttps) {
        this.forceHttps = forceHttps;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    @Override
    public String transformUrl(Context context, CachingOptions cachingOptions, String url) throws UrlTransformationException {
        HttpServletRequest currentRequest = RequestContext.getCurrent().getRequest();
        String scheme = currentRequest.getScheme();
        String domain = currentRequest.getServerName();
        int serverPort = currentRequest.getServerPort();
        if (this.forceHttps) {
            scheme = HTTPS_SCHEME;
            serverPort = this.httpsPort;
        }
        StringBuilder fullUrl = new StringBuilder();
        fullUrl.append(scheme).append("://").append(domain);
        if (!(scheme.equals(HTTP_SCHEME) && serverPort == 80 || scheme.equals(HTTPS_SCHEME) && serverPort == 443)) {
            fullUrl.append(":").append(serverPort);
        }
        if (!url.startsWith("/")) {
            fullUrl.append("/");
        }
        fullUrl.append(url);
        return fullUrl.toString();
    }
}

