/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.url.impl;

import javax.servlet.ServletContext;
import org.craftercms.core.exception.UrlTransformationException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.url.UrlTransformer;
import org.springframework.web.context.ServletContextAware;

public class AddContextPathUrlTransformer
implements UrlTransformer,
ServletContextAware {
    private ServletContext servletContext;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public String transformUrl(Context context, CachingOptions cachingOptions, String url) throws UrlTransformationException {
        if (this.servletContext == null) {
            throw new IllegalStateException("No ServletContext was set. Are you sure you're running in a servlet environment?");
        }
        String contextPath = this.servletContext.getContextPath();
        if (contextPath.equals("/") && url.startsWith("/")) {
            return url;
        }
        return contextPath + url;
    }
}

