/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.store.impl.filesystem;

import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.validation.ValidationResult;
import org.craftercms.commons.validation.validators.Validator;
import org.craftercms.core.exception.AuthenticationException;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.StoreException;
import org.craftercms.core.service.Context;
import org.craftercms.core.store.impl.AbstractFileBasedContentStoreAdapter;
import org.craftercms.core.store.impl.File;
import org.craftercms.core.store.impl.filesystem.FileSystemContext;
import org.craftercms.core.store.impl.filesystem.FileSystemFile;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class FileSystemContentStoreAdapter
extends AbstractFileBasedContentStoreAdapter
implements ResourceLoaderAware {
    public static final String STORE_TYPE = "filesystem";
    private ResourceLoader resourceLoader;
    private Validator<String> pathValidator;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Required
    public void setPathValidator(Validator<String> pathValidator) {
        this.pathValidator = pathValidator;
    }

    @Override
    public Context createContext(String id, String storeServerUrl, String username, String password, String rootFolderPath, boolean cacheOn, int maxAllowedItemsInCache, boolean ignoreHiddenFiles) throws StoreException, AuthenticationException {
        FileSystemFile rootFolder;
        Resource rootFolderResource = this.resourceLoader.getResource(rootFolderPath);
        if (!rootFolderResource.exists()) {
            throw new StoreException("Root folder " + rootFolderPath + " doesn't exist");
        }
        try {
            rootFolder = new FileSystemFile(rootFolderResource.getFile());
        }
        catch (IOException e) {
            throw new StoreException("Unable to retrieve file handle for root folder " + rootFolderPath, e);
        }
        return new FileSystemContext(id, this, null, rootFolderPath, rootFolder, cacheOn, maxAllowedItemsInCache, ignoreHiddenFiles);
    }

    @Override
    public void destroyContext(Context context) throws InvalidContextException, StoreException, AuthenticationException {
    }

    @Override
    protected File findFile(Context context, String path) {
        this.validatePath(path);
        FileSystemFile rootFolder = ((FileSystemContext)context).getRootFolder();
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            FileSystemFile file = new FileSystemFile(rootFolder, path);
            if (file.getFile().exists()) {
                return file;
            }
            return null;
        }
        return rootFolder;
    }

    @Override
    protected List<File> getChildren(Context context, File dir) {
        java.io.File[] listing = context.ignoreHiddenFiles() ? ((FileSystemFile)dir).getFile().listFiles(IgnoreHiddenFileFilter.INSTANCE) : ((FileSystemFile)dir).getFile().listFiles();
        if (listing != null) {
            ArrayList<File> children = new ArrayList<File>(listing.length);
            for (java.io.File file : listing) {
                children.add(new FileSystemFile(file));
            }
            return children;
        }
        return null;
    }

    protected void validatePath(String path) throws StoreException {
        ValidationResult result = new ValidationResult();
        if (!this.pathValidator.validate((Object)path, result)) {
            throw new StoreException("Validation of path " + path + " failed. Errors: " + result.getErrors());
        }
    }

    private static class IgnoreHiddenFileFilter
    implements FileFilter {
        public static final IgnoreHiddenFileFilter INSTANCE = new IgnoreHiddenFileFilter();

        private IgnoreHiddenFileFilter() {
        }

        @Override
        public boolean accept(java.io.File pathname) {
            return !pathname.isHidden();
        }
    }
}

